/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalog;
import io.quarkus.devtools.codestarts.CodestartPathLoader;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.CodestartSpec;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CodestartCatalogLoader {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});

    private CodestartCatalogLoader() {
    }

    public static CodestartCatalog<CodestartProjectInput> loadDefaultCatalog(CodestartPathLoader pathLoader, String first, String ... more) throws IOException {
        List<Codestart> codestarts = CodestartCatalogLoader.loadCodestarts(pathLoader, first, more);
        return new GenericCodestartCatalog<CodestartProjectInput>(codestarts);
    }

    public static Collection<Codestart> loadUserDirectoryCodestarts(Path directory) throws IOException {
        return CodestartCatalogLoader.loadCodestarts(new UserDirectoryCodestartPathLoader(directory), "");
    }

    public static List<Codestart> loadCodestarts(CodestartPathLoader pathLoader, String first, String ... more) throws IOException {
        ArrayList<Codestart> codestarts = new ArrayList<Codestart>(CodestartCatalogLoader.loadCodestarts(pathLoader, first));
        if (more != null) {
            for (String subDir : more) {
                codestarts.addAll(CodestartCatalogLoader.loadCodestarts(pathLoader, subDir));
            }
        }
        return codestarts;
    }

    static Collection<Codestart> loadCodestarts(CodestartPathLoader pathLoader, String directoryName) throws IOException {
        return pathLoader.loadResourceAsPath(directoryName, path -> {
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                List list = pathStream.filter(p -> p.getFileName().toString().matches("codestart\\.yml$")).map(p -> {
                    String resourceName = CodestartCatalogLoader.resolveResourceName(directoryName, path, p);
                    try {
                        CodestartSpec spec = CodestartCatalogLoader.readCodestartSpec(new String(Files.readAllBytes(p)));
                        String resourceCodestartDirectory = resourceName.replaceAll("/?codestart\\.yml", "");
                        return new Codestart(new PathCodestartResourceAllocator(pathLoader, resourceCodestartDirectory), spec, CodestartCatalogLoader.resolveImplementedLanguages(p.getParent()));
                    }
                    catch (IOException e) {
                        throw new CodestartStructureException("Failed to load codestart spec: " + resourceName, e);
                    }
                }).collect(Collectors.toList());
                return list;
            }
        });
    }

    private static Set<String> resolveImplementedLanguages(Path p) throws IOException {
        try (Stream<Path> files = Files.list(p);){
            Set<String> set = files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(CodestartCatalogLoader::getDirName).filter(l -> !Objects.equals(l, "base")).collect(Collectors.toSet());
            return set;
        }
    }

    static CodestartSpec readCodestartSpec(String content) throws JsonProcessingException {
        return (CodestartSpec)YAML_MAPPER.readerFor(CodestartSpec.class).readValue(content);
    }

    static String getDirName(Path d) {
        return d.getFileName().toString().replaceAll("([/\\\\])$", "");
    }

    static String resolveResourceName(String dirName, Path dirPath, Path resourcePath) {
        return CodestartCatalogLoader.getResourcePath(dirName, dirPath.relativize(resourcePath).toString());
    }

    static String getResourcePath(String first, String ... more) {
        return Paths.get(first, more).toString().replace('\\', '/');
    }

    private static class UserDirectoryCodestartPathLoader
    implements CodestartPathLoader {
        private final Path userDir;

        public UserDirectoryCodestartPathLoader(Path userDir) {
            this.userDir = userDir;
        }

        @Override
        public <T> T loadResourceAsPath(String name, CodestartPathLoader.PathConsumer<T> consumer) throws IOException {
            return consumer.consume(this.userDir.resolve(name));
        }
    }

    private static class PathCodestartResourceAllocator
    implements Codestart.CodestartResourceAllocator {
        private final CodestartPathLoader pathLoader;
        private final String resourceName;

        public PathCodestartResourceAllocator(CodestartPathLoader pathLoader, String resourceName) {
            this.pathLoader = pathLoader;
            this.resourceName = resourceName;
        }

        @Override
        public void allocate(Consumer<CodestartResource> readerConsumer) {
            try {
                this.pathLoader.loadResourceAsPath(this.resourceName, p -> {
                    readerConsumer.accept(new CodestartResource.PathCodestartResource(p));
                    return null;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

