/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.function.BooleanSupplier;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.ClassUtils;

@TargetClass(className="org.flywaydb.database.sqlserver.SQLServerDatabaseType", onlyWith={SQLServerAvailable.class})
public final class SQLServerDatabaseTypeSubstitutions {
    @Substitute
    public Object createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SQLServerDatabaseSubstitution(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public static final class SQLServerAvailable
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ClassUtils.isPresent((String)"org.flywaydb.database.sqlserver.SQLServerDatabaseType", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    @TargetClass(className="org.flywaydb.database.sqlserver.SQLServerDatabase", onlyWith={SQLServerAvailable.class})
    public static final class SQLServerDatabaseSubstitution {
        @Alias
        public SQLServerDatabaseSubstitution(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        }
    }
}

