/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import io.quarkus.test.junit.internal.DeepClone;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

class SerializationDeepClone
implements DeepClone {
    private final ClassLoader classLoader;

    SerializationDeepClone(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object clone(Object objectToClone) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(512);
        try (ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
            Object object;
            objOut.writeObject(objectToClone);
            try (ClassLoaderAwareObjectInputStream objIn = new ClassLoaderAwareObjectInputStream(byteOut);){
                object = objIn.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Unable to deep clone object of type '" + objectToClone.getClass().getName() + "'. Please report the issue on the Quarkus issue tracker.", e);
        }
    }

    private class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        public ClassLoaderAwareObjectInputStream(ByteArrayOutputStream byteOut) throws IOException {
            super(new ByteArrayInputStream(byteOut.toByteArray()));
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            return Class.forName(desc.getName(), true, SerializationDeepClone.this.classLoader);
        }
    }
}

