/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BlockingTaskRunner<T>
implements OidcRequestContext<T> {
    @Override
    public Uni<T> runBlocking(final Supplier<T> function) {
        return Uni.createFrom().deferred(new Supplier<Uni<? extends T>>(){

            @Override
            public Uni<T> get() {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    try {
                        return Uni.createFrom().item(function.get());
                    }
                    catch (Throwable t) {
                        return Uni.createFrom().failure(t);
                    }
                }
                return Uni.createFrom().emitter(new Consumer<UniEmitter<? super T>>(){

                    @Override
                    public void accept(final UniEmitter<? super T> uniEmitter) {
                        ExecutorRecorder.getCurrent().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    uniEmitter.complete(function.get());
                                }
                                catch (Throwable t) {
                                    uniEmitter.fail(t);
                                }
                            }
                        });
                    }
                });
            }
        });
    }
}

