/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.mapping;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.resteasy.reactive.server.mapping.Dumpable;
import org.jboss.resteasy.reactive.server.mapping.SubstringMap;

public class PathMatcher<T>
implements Dumpable {
    private static final String STRING_PATH_SEPARATOR = "/";
    private volatile T defaultHandler;
    private final SubstringMap<T> paths = new SubstringMap();
    private final ConcurrentMap<String, T> exactPathMatches = new ConcurrentHashMap<String, T>();
    private volatile int[] lengths = new int[0];

    public PathMatcher(T defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathMatcher() {
    }

    public PathMatch<T> match(String path) {
        T match;
        if (!this.exactPathMatches.isEmpty() && (match = this.getExactPath(path)) != null) {
            return new PathMatch<T>(path, "", match);
        }
        int length = path.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            SubstringMap.SubstringMatch<T> next;
            int pathLength = lengths[i];
            if (pathLength == length) {
                next = this.paths.get(path, length);
                if (next == null) continue;
                return new PathMatch<T>(path, "", next.getValue());
            }
            if (pathLength >= length || (next = this.paths.get(path, pathLength)) == null) continue;
            return new PathMatch<T>(next.getKey(), path.substring(pathLength), next.getValue());
        }
        return new PathMatch<T>(STRING_PATH_SEPARATOR, path, this.defaultHandler);
    }

    public synchronized PathMatcher addPrefixPath(String path, T handler) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path not specified");
        }
        if (STRING_PATH_SEPARATOR.equals(path)) {
            this.defaultHandler = handler;
            return this;
        }
        if (path.endsWith(STRING_PATH_SEPARATOR)) {
            throw new RuntimeException("Prefix path cannot end with /");
        }
        this.paths.put(path, handler);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher addExactPath(String path, T handler) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path not specified");
        }
        this.exactPathMatches.put(path, handler);
        return this;
    }

    public T getExactPath(String path) {
        return (T)this.exactPathMatches.get(path);
    }

    public T getPrefixPath(String path) {
        SubstringMap.SubstringMatch<T> match = this.paths.get(path);
        if (STRING_PATH_SEPARATOR.equals(path) && match == null) {
            return this.defaultHandler;
        }
        if (match == null) {
            return null;
        }
        return match.getValue();
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.paths.keys()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator iterator = lengths.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    @Deprecated
    public synchronized PathMatcher removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathMatcher removePrefixPath(String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path not specified");
        }
        if (STRING_PATH_SEPARATOR.equals(path)) {
            this.defaultHandler = null;
            return this;
        }
        this.paths.remove(path);
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher removeExactPath(String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path not specified");
        }
        this.exactPathMatches.remove(path);
        return this;
    }

    public synchronized PathMatcher clearPaths() {
        this.paths.clear();
        this.exactPathMatches.clear();
        this.lengths = new int[0];
        this.defaultHandler = null;
        return this;
    }

    public Map<String, T> getPaths() {
        return this.paths.toMap();
    }

    @Override
    public void dump(int level) {
        System.err.println("Paths: " + this.paths.size());
        for (String string : this.paths.keys()) {
            System.err.println(" " + string + ": ");
            SubstringMap.SubstringMatch<T> match = this.paths.get(string);
            System.err.println("  matchKey: " + match.getKey());
            System.err.println("  matchValue: ");
            this.dumpValue(match.getValue(), 3);
        }
        System.err.println("Exact path matches: " + this.exactPathMatches.size());
        for (Map.Entry entry : this.exactPathMatches.entrySet()) {
            System.err.println(" " + (String)entry.getKey() + ": ");
            this.dumpValue(entry.getValue(), 2);
        }
        System.err.println("Default handler: " + this.defaultHandler);
    }

    private void dumpValue(T value, int level) {
        if (value instanceof List) {
            for (Object x : (List)value) {
                if (!(x instanceof Dumpable)) continue;
                ((Dumpable)x).dump(level);
            }
        }
    }

    public static final class PathMatch<T> {
        private final String matched;
        private final String remaining;
        private final T value;

        public PathMatch(String matched, String remaining, T value) {
            this.matched = matched;
            this.remaining = remaining;
            this.value = value;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getMatched() {
            return this.matched;
        }

        public T getValue() {
            return this.value;
        }
    }
}

