/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.datasource;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaDataFactory;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class ShardingDataSourceMetaData {
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public ShardingDataSourceMetaData(Map<String, String> dataSourceURLs, ShardingRule shardingRule, DatabaseType databaseType) {
        this.dataSourceMetaDataMap = this.getDataSourceMetaDataMap(dataSourceURLs, shardingRule, databaseType);
    }

    private Map<String, DataSourceMetaData> getDataSourceMetaDataMap(Map<String, String> dataSourceURLs, ShardingRule shardingRule, DatabaseType databaseType) {
        Map<String, DataSourceMetaData> dataSourceMetaData = this.getDataSourceMetaDataMapForSharding(dataSourceURLs, databaseType);
        return shardingRule.getMasterSlaveRules().isEmpty() ? dataSourceMetaData : this.getDataSourceMetaDataMapForMasterSlave(shardingRule, dataSourceMetaData);
    }

    private Map<String, DataSourceMetaData> getDataSourceMetaDataMapForSharding(Map<String, String> dataSourceURLs, DatabaseType databaseType) {
        LinkedHashMap<String, DataSourceMetaData> result = new LinkedHashMap<String, DataSourceMetaData>(dataSourceURLs.size(), 1.0f);
        for (Map.Entry<String, String> entry : dataSourceURLs.entrySet()) {
            result.put(entry.getKey(), DataSourceMetaDataFactory.newInstance(databaseType, entry.getValue()));
        }
        return result;
    }

    private Map<String, DataSourceMetaData> getDataSourceMetaDataMapForMasterSlave(ShardingRule shardingRule, Map<String, DataSourceMetaData> dataSourceMetaDataMap) {
        LinkedHashMap<String, DataSourceMetaData> result = new LinkedHashMap<String, DataSourceMetaData>(dataSourceMetaDataMap);
        for (Map.Entry<String, DataSourceMetaData> entry : dataSourceMetaDataMap.entrySet()) {
            Optional<MasterSlaveRule> masterSlaveRule = shardingRule.findMasterSlaveRule(entry.getKey());
            if (!masterSlaveRule.isPresent() || !((MasterSlaveRule)masterSlaveRule.get()).getMasterDataSourceName().equals(entry.getKey())) continue;
            this.reviseMasterSlaveMetaData(result, entry.getValue(), (MasterSlaveRule)masterSlaveRule.get());
        }
        return result;
    }

    private void reviseMasterSlaveMetaData(Map<String, DataSourceMetaData> dataSourceMetaDataMap, DataSourceMetaData masterSlaveDataSourceMetaData, MasterSlaveRule masterSlaveRule) {
        dataSourceMetaDataMap.put(masterSlaveRule.getName(), masterSlaveDataSourceMetaData);
        dataSourceMetaDataMap.remove(masterSlaveRule.getMasterDataSourceName());
        for (String each : masterSlaveRule.getSlaveDataSourceNames()) {
            dataSourceMetaDataMap.remove(each);
        }
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        for (String each : existedDataSourceNames) {
            if (!this.dataSourceMetaDataMap.get(each).isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(dataSourceName))) continue;
            return true;
        }
        return false;
    }

    public DataSourceMetaData getActualDataSourceMetaData(String actualDataSourceName) {
        return this.dataSourceMetaDataMap.get(actualDataSourceName);
    }
}

