/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.adapter;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.jdbc.unsupported.AbstractUnsupportedOperationConnection;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractConnectionAdapter
extends AbstractUnsupportedOperationConnection {
    private final Map<String, Connection> cachedConnections = new HashMap<String, Connection>();
    private boolean autoCommit = true;
    private boolean readOnly = true;
    private boolean closed;
    private int transactionIsolation = 1;

    public final Connection getConnection(String dataSourceName) throws SQLException {
        if (this.cachedConnections.containsKey(dataSourceName)) {
            return this.cachedConnections.get(dataSourceName);
        }
        DataSource dataSource = this.getDataSourceMap().get(dataSourceName);
        Preconditions.checkState((null != dataSource ? 1 : 0) != 0, (String)"Missing the data source name: '%s'", (Object[])new Object[]{dataSourceName});
        Connection result = dataSource.getConnection();
        this.cachedConnections.put(dataSourceName, result);
        this.replayMethodsInvocation(result);
        return result;
    }

    protected abstract Map<String, DataSource> getDataSourceMap();

    protected void removeCache(Connection connection) {
        this.cachedConnections.values().remove(connection);
    }

    @Override
    public final boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{autoCommit});
        for (Connection each : this.cachedConnections.values()) {
            each.setAutoCommit(autoCommit);
        }
    }

    @Override
    public final void commit() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final void rollback() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        HintManagerHolder.clear();
        MasterVisitedManager.clear();
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
        this.recordMethodInvocation(Connection.class, "setReadOnly", new Class[]{Boolean.TYPE}, new Object[]{readOnly});
        for (Connection each : this.cachedConnections.values()) {
            each.setReadOnly(readOnly);
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        if (this.cachedConnections.values().isEmpty()) {
            return this.transactionIsolation;
        }
        return this.cachedConnections.values().iterator().next().getTransactionIsolation();
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
        this.recordMethodInvocation(Connection.class, "setTransactionIsolation", new Class[]{Integer.TYPE}, new Object[]{level});
        for (Connection each : this.cachedConnections.values()) {
            each.setTransactionIsolation(level);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public final int getHoldability() {
        return 2;
    }

    @Override
    public final void setHoldability(int holdability) {
    }
}

