/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingContext {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;
    private final ExecutorEngine executorEngine;
    private final ShardingMetaData shardingMetaData;
    private final boolean showSQL;

    @ConstructorProperties(value={"dataSourceMap", "shardingRule", "databaseType", "executorEngine", "shardingMetaData", "showSQL"})
    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ExecutorEngine executorEngine, ShardingMetaData shardingMetaData, boolean showSQL) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
        this.executorEngine = executorEngine;
        this.shardingMetaData = shardingMetaData;
        this.showSQL = showSQL;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    public ShardingMetaData getShardingMetaData() {
        return this.shardingMetaData;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }
}

