/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.statement;

import com.google.common.base.Optional;
import io.shardingsphere.core.executor.type.statement.StatementExecutor;
import io.shardingsphere.core.executor.type.statement.StatementUnit;
import io.shardingsphere.core.jdbc.adapter.AbstractStatementAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.core.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.core.jdbc.metadata.dialect.JDBCShardingRefreshHandler;
import io.shardingsphere.core.merger.JDBCQueryResult;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.StatementRoutingEngine;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Collection<Statement> routedStatements = new LinkedList<Statement>();
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingResultSet result;
        try {
            List<ResultSet> resultSets = this.generateExecutor(sql).executeQuery();
            ArrayList<JDBCQueryResult> queryResults = new ArrayList<JDBCQueryResult>(resultSets.size());
            for (ResultSet each : resultSets) {
                queryResults.add(new JDBCQueryResult(each));
            }
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement());
            result = new ShardingResultSet(resultSets, mergeEngine.merge(), this);
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.generateExecutor(sql).executeUpdate();
            return n;
        }
        finally {
            JDBCShardingRefreshHandler.build(this.routeResult, this.connection).execute();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            int n = this.generateExecutor(sql).executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            int n = this.generateExecutor(sql).executeUpdate(columnNames);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            boolean bl = this.generateExecutor(sql).execute();
            return bl;
        }
        finally {
            JDBCShardingRefreshHandler.build(this.routeResult, this.connection).execute();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            boolean bl = this.generateExecutor(sql).execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            boolean bl = this.generateExecutor(sql).execute(columnIndexes);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            boolean bl = this.generateExecutor(sql).execute(columnNames);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private StatementExecutor generateExecutor(String sql) throws SQLException {
        this.clearPrevious();
        ShardingContext shardingContext = this.connection.getShardingContext();
        this.routeResult = new StatementRoutingEngine(shardingContext.getShardingRule(), shardingContext.getShardingMetaData(), shardingContext.getDatabaseType(), shardingContext.isShowSQL()).route(sql);
        LinkedList<StatementUnit> statementUnits = new LinkedList<StatementUnit>();
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            Statement statement = this.connection.getConnection(each.getDataSource()).createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
            this.replayMethodsInvocation(statement);
            statementUnits.add(new StatementUnit(each, statement));
            this.routedStatements.add(statement);
        }
        return new StatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), statementUnits);
    }

    private void clearPrevious() throws SQLException {
        for (Statement each : this.routedStatements) {
            each.close();
        }
        this.routedStatements.clear();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        ArrayList<JDBCQueryResult> queryResults = new ArrayList<JDBCQueryResult>(this.routedStatements.size());
        for (Statement each : this.routedStatements) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new JDBCQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement());
            this.currentResultSet = new ShardingResultSet(resultSets, mergeEngine.merge(), this);
        }
        return this.currentResultSet;
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Collection<Statement> getRoutedStatements() {
        return this.routedStatements;
    }
}

