/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceUtil {
    private static final String SET_METHOD_PREFIX = "set";
    private static Collection<Class<?>> generalClassType = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class});

    public static DataSource getDataSource(String dataSourceClassName, Map<String, Object> dataSourceProperties) throws ReflectiveOperationException {
        DataSource result = (DataSource)Class.forName(dataSourceClassName).newInstance();
        for (Map.Entry<String, Object> entry : dataSourceProperties.entrySet()) {
            DataSourceUtil.callSetterMethod(result, DataSourceUtil.getSetterMethodName(entry.getKey()), null == entry.getValue() ? null : entry.getValue().toString());
        }
        return result;
    }

    private static String getSetterMethodName(String propertyName) {
        if (propertyName.contains("-")) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, "set-" + propertyName);
        }
        return SET_METHOD_PREFIX + String.valueOf(propertyName.charAt(0)).toUpperCase() + propertyName.substring(1, propertyName.length());
    }

    private static void callSetterMethod(DataSource dataSource, String methodName, String setterValue) {
        for (Class<?> each : generalClassType) {
            try {
                Method method = dataSource.getClass().getMethod(methodName, each);
                if (Boolean.TYPE == each || Boolean.class == each) {
                    method.invoke((Object)dataSource, Boolean.valueOf(setterValue));
                } else if (Integer.TYPE == each || Integer.class == each) {
                    method.invoke((Object)dataSource, Integer.parseInt(setterValue));
                } else if (Long.TYPE == each || Long.class == each) {
                    method.invoke((Object)dataSource, Long.parseLong(setterValue));
                } else {
                    method.invoke((Object)dataSource, setterValue);
                }
                return;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
    }

    private DataSourceUtil() {
    }
}

