/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigSourceUtil {
    public static final String CONFIG_ORDINAL_KEY = "config_ordinal";
    public static final String CONFIG_ORDINAL_100 = "100";

    private ConfigSourceUtil() {
    }

    public static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            map.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
        }
        return map;
    }

    public static Map<String, String> urlToMap(URL locationOfProperties) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(locationOfProperties.openStream(), StandardCharsets.UTF_8);){
            Properties p = new Properties();
            p.load(reader);
            Map<String, String> map = ConfigSourceUtil.propertiesToMap(p);
            return map;
        }
    }

    public static int getOrdinalFromMap(Map<String, String> map, int defaultOrdinal) {
        String ordStr = map.get(CONFIG_ORDINAL_KEY);
        return ordStr == null ? defaultOrdinal : Integer.parseInt(ordStr);
    }
}

