/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOnFailureResumeOp;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MultiFlatMapOnFailure<T>
extends MultiOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, Multi<? extends T>> mapper;

    public MultiFlatMapOnFailure(Multi<T> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, Multi<? extends T>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.predicate = predicate == null ? x -> true : predicate;
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber must not be `null`");
        Function<Throwable, Publisher> next = failure -> {
            if (this.predicate.test((Throwable)failure)) {
                Publisher res = this.mapper.apply((Throwable)failure);
                if (res == null) {
                    return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
                }
                return res;
            }
            return Multi.createFrom().failure((Throwable)failure);
        };
        Multi op = Infrastructure.onMultiCreation(new MultiOnFailureResumeOp(this.upstream(), next));
        op.subscribe(subscriber);
    }
}

