/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public final class MultiScanWithSeedOp<T, R>
extends AbstractMultiOperator<T, R> {
    private final BiFunction<R, ? super T, R> accumulator;
    private final Supplier<R> seed;

    public MultiScanWithSeedOp(Multi<? extends T> upstream, Supplier<R> seed, BiFunction<R, ? super T, R> accumulator) {
        super(upstream);
        this.seed = ParameterValidation.nonNull(seed, "seed");
        this.accumulator = ParameterValidation.nonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(MultiSubscriber<? super R> downstream) {
        ScanSubscriber<T, R> subscriber = new ScanSubscriber<T, R>(this.upstream, downstream, this.accumulator, this.seed);
        downstream.onSubscribe(subscriber);
        if (!subscriber.isCancelled()) {
            subscriber.onCompletion();
        }
    }

    private static final class ScanSeedProcessor<T, R>
    extends MultiOperatorProcessor<T, R> {
        private final BiFunction<R, ? super T, R> accumulator;
        R current;

        ScanSeedProcessor(MultiSubscriber<? super R> downstream, BiFunction<R, ? super T, R> accumulator, R initial) {
            super(downstream);
            this.accumulator = accumulator;
            this.current = initial;
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.current = null;
        }

        @Override
        public void onFailure(Throwable failure) {
            super.onFailure(failure);
            this.current = null;
        }

        @Override
        public void onItem(T t) {
            if (this.isDone()) {
                return;
            }
            R r = this.current;
            try {
                r = this.accumulator.apply(r, t);
            }
            catch (Throwable e) {
                this.onFailure(e);
                return;
            }
            if (r == null) {
                this.onFailure(new NullPointerException("The accumulator returned a null value"));
                return;
            }
            this.downstream.onItem(r);
            this.current = r;
        }
    }

    static final class ScanSubscriber<T, R>
    extends SwitchableSubscriptionSubscriber<R> {
        private final Multi<? extends T> upstream;
        private final Supplier<R> initialSupplier;
        private final BiFunction<R, ? super T, R> accumulator;
        private final AtomicInteger wip = new AtomicInteger();
        long produced;
        private ScanSeedProcessor<T, R> subscriber;

        ScanSubscriber(Multi<? extends T> upstream, MultiSubscriber<? super R> downstream, BiFunction<R, ? super T, R> accumulator, Supplier<R> seed) {
            super(downstream);
            this.upstream = upstream;
            this.accumulator = accumulator;
            this.initialSupplier = seed;
        }

        @Override
        public void onCompletion() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    if (this.subscriber != null && this.currentUpstream.get() == this.subscriber) {
                        this.downstream.onCompletion();
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.emitted(p);
                    }
                    if (this.subscriber == null) {
                        R initialValue;
                        try {
                            initialValue = this.initialSupplier.get();
                        }
                        catch (Throwable e) {
                            this.onFailure(e);
                            return;
                        }
                        if (initialValue == null) {
                            this.onFailure(new NullPointerException("The seed cannot be `null`"));
                            return;
                        }
                        this.onSubscribe(Subscriptions.single(this, initialValue));
                        this.subscriber = new ScanSeedProcessor<T, R>(this, this.accumulator, initialValue);
                    } else {
                        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, this.subscriber));
                    }
                    if (!this.isCancelled()) continue;
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        @Override
        public void onItem(R r) {
            ++this.produced;
            this.downstream.onItem(r);
        }
    }
}

