/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.vertx.mutiny.core.Vertx;
import java.util.function.BiConsumer;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class KafkaIgnoreFailure
implements KafkaFailureHandler {
    private final String channel;

    public KafkaIgnoreFailure(String channel) {
        this.channel = channel;
    }

    @Override
    public <K, V> Uni<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason, Metadata metadata) {
        KafkaLogging.log.messageNackedIgnore(this.channel, reason.getMessage());
        KafkaLogging.log.messageNackedFullIgnored(reason);
        return Uni.createFrom().completionStage(record.ack());
    }

    @ApplicationScoped
    @Identifier(value="ignore")
    public static class Factory
    implements KafkaFailureHandler.Factory {
        @Override
        public KafkaFailureHandler create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure) {
            return new KafkaIgnoreFailure(config.getChannel());
        }
    }
}

