/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.reply;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.kafka.reply.BytesCorrelationId;
import io.smallrye.reactive.messaging.kafka.reply.CorrelationId;
import io.smallrye.reactive.messaging.kafka.reply.CorrelationIdHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.SecureRandom;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
@Identifier(value="bytes")
public class BytesCorrelationIdHandler
implements CorrelationIdHandler {
    @Inject
    @ConfigProperty(name="smallrye.kafka.request-reply.correlation-id.bytes.length", defaultValue="12")
    int bytesLength;
    private final SecureRandom random = new SecureRandom();

    @Override
    public CorrelationId generate(Message<?> request) {
        byte[] bytes = new byte[this.bytesLength];
        this.random.nextBytes(bytes);
        return new BytesCorrelationId(bytes);
    }

    @Override
    public CorrelationId parse(byte[] bytes) {
        return new BytesCorrelationId(bytes);
    }
}

