/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLScalarType;
import io.smallrye.graphql.scalar.AbstractScalar;
import io.smallrye.graphql.scalar.number.BigDecimalScalar;
import io.smallrye.graphql.scalar.number.BigIntegerScalar;
import io.smallrye.graphql.scalar.number.FloatScalar;
import io.smallrye.graphql.scalar.number.IntegerScalar;
import io.smallrye.graphql.scalar.others.VoidScalar;
import io.smallrye.graphql.scalar.time.DateScalar;
import io.smallrye.graphql.scalar.time.DateTimeScalar;
import io.smallrye.graphql.scalar.time.DurationScalar;
import io.smallrye.graphql.scalar.time.PeriodScalar;
import io.smallrye.graphql.scalar.time.TimeScalar;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GraphQLScalarTypes {
    private static final Map<String, GraphQLScalarType> SCALAR_MAP = new HashMap<String, GraphQLScalarType>();
    private static final Map<String, GraphQLScalarType> SCALARS_BY_NAME = new HashMap<String, GraphQLScalarType>();
    private static final String ID = "ID";

    private GraphQLScalarTypes() {
    }

    public static Map<String, GraphQLScalarType> getScalarMap() {
        return SCALAR_MAP;
    }

    public static GraphQLScalarType getScalarByName(String name) {
        return SCALARS_BY_NAME.get(name);
    }

    public static GraphQLScalarType getScalarByClassName(String className) {
        return SCALAR_MAP.get(className);
    }

    public static boolean isGraphQLScalarType(String className) {
        return SCALAR_MAP.containsKey(className);
    }

    public static void addUuid() {
        SCALAR_MAP.put(UUID.class.getName(), ExtendedScalars.UUID);
        SCALARS_BY_NAME.put(ExtendedScalars.UUID.getName(), ExtendedScalars.UUID);
    }

    private static void mapType(AbstractScalar abstractScalar) {
        for (Class c : abstractScalar.getSupportedClasses()) {
            SCALAR_MAP.put(c.getName(), abstractScalar.getScalarType());
        }
    }

    static {
        SCALAR_MAP.put(ID, Scalars.GraphQLID);
        SCALAR_MAP.put(Boolean.class.getName(), Scalars.GraphQLBoolean);
        SCALAR_MAP.put(Boolean.TYPE.getName(), Scalars.GraphQLBoolean);
        SCALAR_MAP.put(Character.TYPE.getName(), Scalars.GraphQLString);
        SCALAR_MAP.put(Character.class.getName(), Scalars.GraphQLString);
        SCALAR_MAP.put(String.class.getName(), Scalars.GraphQLString);
        SCALAR_MAP.put(UUID.class.getName(), Scalars.GraphQLString);
        SCALAR_MAP.put("org.bson.types.ObjectId", Scalars.GraphQLString);
        SCALAR_MAP.put(URL.class.getName(), Scalars.GraphQLString);
        SCALAR_MAP.put(URI.class.getName(), Scalars.GraphQLString);
        GraphQLScalarTypes.mapType(new IntegerScalar());
        GraphQLScalarTypes.mapType(new FloatScalar());
        GraphQLScalarTypes.mapType(new BigIntegerScalar());
        GraphQLScalarTypes.mapType(new BigDecimalScalar());
        GraphQLScalarTypes.mapType(new DateScalar());
        GraphQLScalarTypes.mapType(new TimeScalar());
        GraphQLScalarTypes.mapType(new DateTimeScalar());
        GraphQLScalarTypes.mapType(new PeriodScalar());
        GraphQLScalarTypes.mapType(new DurationScalar());
        GraphQLScalarTypes.mapType(new VoidScalar());
        for (GraphQLScalarType value : SCALAR_MAP.values()) {
            SCALARS_BY_NAME.put(value.getName(), value);
        }
    }
}

