/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Member;
import javax.management.MalformedObjectNameException;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRMET", length=5)
public interface SmallRyeMetricsMessages {
    public static final SmallRyeMetricsMessages msg = (SmallRyeMetricsMessages)Messages.getBundle(SmallRyeMetricsMessages.class);

    @Message(id=0, value="Unknown metric type")
    public IllegalArgumentException unknownMetricType();

    @Message(id=2, value="No metric of type %s and ID %s found in registry")
    public IllegalStateException noMetricFoundInRegistry(MetricType var1, MetricID var2);

    @Message(id=3, value="No metric mapped for %s")
    public IllegalStateException noMetricMappedForMember(Member var1);

    @Message(id=4, value="Unable to retrieve name for parameter %s")
    public UnsupportedOperationException unableToRetrieveParameterName(AnnotatedParameter<?> var1);

    @Message(id=5, value="Unable to retrieve metric name for injection point %s")
    public UnsupportedOperationException unableToRetrieveMetricNameForInjectionPoint(InjectionPoint var1);

    @Message(id=6, value="No metric is present")
    public IllegalStateException noMetricPresent();

    @Message(id=7, value="Not a valid key=value pair: %s")
    public IllegalArgumentException notAKeyValuePair(String var1);

    @Message(id=8, value="Method must not be called")
    public IllegalStateException mustNotBeCalled();

    @Message(id=9, value="Gauge with id %s already exists")
    public IllegalArgumentException gaugeWithIdAlreadyExists(MetricID var1);

    @Message(id=10, value="Metric name must not be null or empty")
    public IllegalArgumentException metricNameMustNotBeNullOrEmpty();

    @Message(id=11, value="Metric %s already exists under a different type (%s)")
    public IllegalStateException metricExistsUnderDifferentType(String var1, String var2);

    @Message(id=12, value="Unit is different from the unit in previous usage (%s)")
    public IllegalStateException unitDiffersFromPreviousUsage(String var1);

    @Message(id=13, value="Description is different from the description in previous usage")
    public IllegalStateException descriptionDiffersFromPreviousUsage();

    @Message(id=14, value="Display name is different from the display name in previous usage")
    public IllegalStateException displayNameDiffersFromPreviousUsage();

    @Message(id=15, value="A metric with name %s already exists")
    public IllegalStateException metricWithNameAlreadyExists(String var1);

    @Message(id=16, value="Unable to infer a metric type")
    public IllegalStateException unableToInferMetricType();

    @Message(id=17, value="Attempting to register a %s, but the passed metadata contains type=%s")
    public IllegalArgumentException typeMismatch(MetricType var1, MetricType var2);

    @Message(id=18, value="Ambiguous metric type, %s and %s are possible")
    public IllegalArgumentException ambiguousMetricType(MetricType var1, MetricType var2);

    @Message(id=19, value="Unknown metric annotation type %s")
    public IllegalArgumentException unknownMetricAnnotationType(Class<?> var1);

    @Message(id=20, value="Malformed object name")
    public IllegalStateException malformedObjectName(@Cause MalformedObjectNameException var1);
}

