/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.models.properties.Property;
import java.util.Arrays;

public abstract class AbstractAdaCodegen
extends DefaultCodegen
implements CodegenConfig {
    public AbstractAdaCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at", "begin", "body", "case", "constant", "declare", "delay", "digits", "do", "else", "elsif", "end", "entry", "exception", "exit", "for", "function", "generic", "goto", "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or", "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected", "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select", "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then", "type", "until", "use", "when", "while", "with", "xor"));
    }

    protected String toAdaIdentifier(String name, String prefix) {
        if (this.isReservedWord(name)) {
            LOGGER.warn("Identifier '" + name + "' is a reserved word, renamed to " + prefix + name);
            name = prefix + name;
        }
        StringBuilder result = new StringBuilder();
        boolean needUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (needUpperCase) {
                needUpperCase = false;
                result.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (!needUpperCase) {
                    result.append('_');
                }
                result.append(c);
                needUpperCase = false;
                continue;
            }
            result.append(c);
            if (c != '_') continue;
            needUpperCase = true;
        }
        return result.toString();
    }

    @Override
    public String toOperationId(String operationId) {
        return this.toAdaIdentifier(this.sanitizeName(operationId), "Call_");
    }

    @Override
    public String toVarName(String name) {
        return this.toAdaIdentifier(this.sanitizeName(name), "P_");
    }

    @Override
    public String toParamName(String name) {
        return this.toAdaIdentifier(super.toParamName(name), "P_");
    }

    @Override
    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty property = super.fromProperty(name, p);
        String nameInCamelCase = property.nameInCamelCase;
        property.nameInCamelCase = nameInCamelCase = this.sanitizeName(nameInCamelCase);
        return property;
    }
}

