/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractAdaCodegen;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AdaCodegen
extends AbstractAdaCodegen
implements CodegenConfig {
    protected String packageName = "swagger";
    protected String projectName = "Swagger";
    protected List<Map<String, Object>> orderedModels;
    protected Map<String, List<String>> modelDepends;

    public AdaCodegen() {
        this.modelNameSuffix = "_Type";
        this.orderedModels = new ArrayList<Map<String, Object>>();
        this.modelDepends = new HashMap<String, List<String>>();
        this.templateDir = "Ada";
        this.embeddedTemplateDir = "Ada";
        this.addOption("projectName", "GNAT project name", this.projectName);
        this.addOption("packageName", "Ada package name (convention: name.space.model).", this.modelPackage);
        this.addOption("modelPackage", "Ada package for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "Ada package for apis (convention: name.space.api).", this.apiPackage);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("integer", "boolean", "Integer", "Character", "Boolean", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "Swagger.Date");
        this.typeMapping.put("DateTime", "Swagger.Datetime");
        this.typeMapping.put("string", "Swagger.UString");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Swagger.Long");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("array", "Swagger.Vector");
        this.typeMapping.put("map", "Swagger.Map");
        this.typeMapping.put("object", "Swagger.Object");
        this.typeMapping.put("number", "Swagger.Number");
        this.typeMapping.put("UUID", "Swagger.UString");
        this.typeMapping.put("file", "Swagger.Http_Content_Type");
        this.typeMapping.put("binary", "Swagger.Binary");
        this.importMapping = new HashMap();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ada";
    }

    @Override
    public String getHelp() {
        return "Generates an Ada client implementation (beta).";
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    public String toFilename(String name) {
        return name.replace(".", "-").toLowerCase();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.packageName = (String)this.additionalProperties.get("packageName");
        }
        String serverPrefix = "src" + File.separator + "server" + File.separator + this.toFilename(this.modelPackage);
        String clientPrefix = "src" + File.separator + "client" + File.separator + this.toFilename(this.modelPackage);
        this.supportingFiles.add(new SupportingFile("model-spec.mustache", null, clientPrefix + "-models.ads"));
        this.supportingFiles.add(new SupportingFile("model-body.mustache", null, clientPrefix + "-models.adb"));
        this.supportingFiles.add(new SupportingFile("model-spec.mustache", null, serverPrefix + "-models.ads"));
        this.supportingFiles.add(new SupportingFile("model-body.mustache", null, serverPrefix + "-models.adb"));
        this.supportingFiles.add(new SupportingFile("client-spec.mustache", null, clientPrefix + "-clients.ads"));
        this.supportingFiles.add(new SupportingFile("client-body.mustache", null, clientPrefix + "-clients.adb"));
        this.supportingFiles.add(new SupportingFile("server-spec.mustache", null, serverPrefix + "-servers.ads"));
        this.supportingFiles.add(new SupportingFile("server-body.mustache", null, serverPrefix + "-servers.adb"));
        this.supportingFiles.add(new SupportingFile("gnat-project.mustache", "", "project.gpr"));
        this.projectName = this.additionalProperties.containsKey("projectName") ? (String)this.additionalProperties.get("projectName") : this.packageName.replaceAll("\\.", "_");
        this.additionalProperties.put("package", this.modelPackage);
        this.additionalProperties.put("projectName", this.projectName);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/model/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "p_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "_Vectors.Vector";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "Swagger." + this.getTypeDeclaration(inner) + "_Map";
        }
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        String modelType = this.toModelName(swaggerType);
        if (p instanceof StringProperty || p instanceof DateProperty || p instanceof DateTimeProperty || p instanceof FileProperty || this.languageSpecificPrimitives.contains(modelType)) {
            return modelType;
        }
        return this.modelPackage + ".Models." + modelType;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        if (!(isModel || parameter.isPrimitiveType || parameter.isDate || parameter.isString || parameter.isContainer || parameter.isFile)) {
            isModel = true;
        }
        parameter.vendorExtensions.put("x-is-model-type", isModel);
    }

    protected int postProcessMediaTypes(List<Map<String, String>> types) {
        int count = 0;
        if (types != null) {
            for (Map<String, String> media : types) {
                String mt = media.get("mediaType");
                if (mt == null) continue;
                mt = mt.replace('/', '_');
                media.put("adaMediaType", mt.toUpperCase());
                ++count;
            }
        }
        return count;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        Response methodResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && methodResponse.getSchema() != null) {
            CodegenProperty cm = this.fromProperty("response", methodResponse.getSchema());
            op.vendorExtensions.put("x-codegen-response", cm);
            if (cm.datatype == "HttpContent") {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        return op;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op1 : operationList) {
            op1.vendorExtensions.put("x-has-uniq-produces", this.postProcessMediaTypes(op1.produces) == 1);
            op1.vendorExtensions.put("x-has-uniq-consumes", this.postProcessMediaTypes(op1.consumes) == 1);
            op1.vendorExtensions.put("x-has-notes", op1.notes.length() > 0);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Map model : models) {
            Object v = model.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel m = (CodegenModel)v;
            ArrayList<String> d = new ArrayList<String>();
            for (CodegenProperty p : m.allVars) {
                boolean isModel = false;
                CodegenProperty item = p;
                if (p.isContainer) {
                    item = p.items;
                }
                if (!(item == null || item.isString || item.isPrimitiveType || item.isContainer || item.isInteger || d.contains(item.datatype))) {
                    d.add(item.datatype);
                    isModel = true;
                }
                p.vendorExtensions.put("x-is-model-type", isModel);
            }
            this.modelDepends.put(m.name, d);
            this.orderedModels.add(model);
        }
        final Map<String, List<String>> deps = this.modelDepends;
        Collections.sort(this.orderedModels, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                List rhsList;
                Object v = lhs.get("model");
                String lhsName = ((CodegenModel)v).name;
                v = rhs.get("model");
                String rhsName = ((CodegenModel)v).name;
                List lhsList = (List)deps.get(lhsName);
                if (lhsList == (rhsList = (List)deps.get(rhsName))) {
                    return lhsName.compareTo(rhsName);
                }
                if (lhsList == null) {
                    return -1;
                }
                if (rhsList == null) {
                    return 1;
                }
                if (lhsList.contains(rhsName)) {
                    return 1;
                }
                if (rhsList.contains(lhsName)) {
                    return -1;
                }
                if (lhsList.size() < rhsList.size()) {
                    return -1;
                }
                if (lhsList.size() > rhsList.size()) {
                    return 1;
                }
                return lhsName.compareTo(rhsName);
            }
        });
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("orderedModels", this.orderedModels);
        return super.postProcessSupportingFileData(objs);
    }
}

