/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexClientCodegen
extends AbstractJavaCodegen {
    private static final String CLASS_PREFIX = "classPrefix";
    private static final String API_VERSION = "apiVersion";
    private static final String BUILD_METHOD = "buildMethod";
    private static final String NAMED_CREDENTIAL = "namedCredential";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApexClientCodegen.class);
    private String classPrefix = "Swag";
    private String apiVersion = "39.0";
    private String buildMethod = "sfdx";
    private String namedCredential = this.classPrefix;
    private String srcPath = "force-app/main/default/";

    public ApexClientCodegen() {
        this.importMapping.clear();
        this.testFolder = this.sourceFolder = this.srcPath;
        this.templateDir = "apex";
        this.embeddedTemplateDir = "apex";
        this.outputFolder = "generated-code" + File.separator + "apex";
        this.apiPackage = "classes";
        this.modelPackage = "classes";
        this.testPackage = "force-app.main.default.classes";
        this.modelNamePrefix = this.classPrefix;
        this.dateLibrary = "";
        this.apiTemplateFiles.put("api.mustache", ".cls");
        this.apiTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.apiTestTemplateFiles.put("api_test.mustache", ".cls");
        this.apiTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTemplateFiles.put("model.mustache", ".cls");
        this.modelTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTestTemplateFiles.put("model_test.mustache", ".cls");
        this.modelTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.cliOptions.add(CliOption.newString(CLASS_PREFIX, "Prefix for generated classes. Set this to avoid overwriting existing classes in your org."));
        this.cliOptions.add(CliOption.newString(API_VERSION, "The Metadata API version number to use for components in this package."));
        this.cliOptions.add(CliOption.newString(BUILD_METHOD, "The build method for this package."));
        this.cliOptions.add(CliOption.newString(NAMED_CREDENTIAL, "The named credential name for the HTTP callouts"));
        this.supportingFiles.add(new SupportingFile("Swagger.cls", this.srcPath + "classes", "Swagger.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "Swagger.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("SwaggerTest.cls", this.srcPath + "classes", "SwaggerTest.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "SwaggerTest.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("SwaggerResponseMock.cls", this.srcPath + "classes", "SwaggerResponseMock.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "SwaggerResponseMock.cls-meta.xml"));
        this.typeMapping.put("BigDecimal", "Double");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "Blob");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Datetime");
        this.typeMapping.put("file", "Blob");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("UUID", "String");
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "activate", "and", "any", "array", "as", "asc", "autonomous", "begin", "bigdecimal", "blob", "break", "bulk", "by", "byte", "case", "cast", "catch", "char", "class", "collect", "commit", "const", "continue", "convertcurrency", "date", "decimal", "default", "delete", "desc", "do", "else", "end", "enum", "exception", "exit", "export", "extends", "false", "final", "finally", "float", "for", "from", "future", "global", "goto", "group", "having", "hint", "if", "implements", "import", "inner", "insert", "instanceof", "int", "interface", "into", "join", "last_90_days", "last_month", "last_n_days", "last_week", "like", "limit", "list", "long", "loop", "map", "merge", "new", "next_90_days", "next_month", "next_n_days", "next_week", "not", "null", "nulls", "number", "object", "of", "on", "or", "outer", "override", "package", "parallel", "pragma", "private", "protected", "public", "retrieve", "return", "returning", "rollback", "savepoint", "search", "select", "set", "short", "sort", "stat", "static", "super", "switch", "synchronized", "system", "testmethod", "then", "this", "this_month", "this_week", "throw", "today", "tolabel", "tomorrow", "transaction", "trigger", "true", "try", "type", "undelete", "update", "upsert", "using", "virtual", "webservice", "when", "where", "while", "yesterday"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Blob", "Boolean", "Date", "Datetime", "Decimal", "Double", "ID", "Integer", "Long", "Object", "String", "Time"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        if (this.additionalProperties.containsKey(API_VERSION)) {
            this.setApiVersion(this.toApiVersion((String)this.additionalProperties.get(API_VERSION)));
        }
        this.additionalProperties.put(API_VERSION, this.apiVersion);
        if (this.additionalProperties.containsKey(BUILD_METHOD)) {
            this.setBuildMethod((String)this.additionalProperties.get(BUILD_METHOD));
        }
        this.additionalProperties.put(BUILD_METHOD, this.buildMethod);
        if (this.additionalProperties.containsKey(NAMED_CREDENTIAL)) {
            this.setNamedCredential((String)this.additionalProperties.get(NAMED_CREDENTIAL));
        }
        this.additionalProperties.put(NAMED_CREDENTIAL, this.namedCredential);
        this.postProcessOpts();
    }

    @Override
    public String escapeReservedWord(String name) {
        return "r" + super.escapeReservedWord(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        if (modelName.length() > 36) {
            modelName = modelName.substring(0, 36);
        }
        return modelName;
    }

    @Override
    public String toDefaultValue(Schema propertySchema) {
        String out = null;
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            out = String.format("new List<%s>()", inner == null ? "Object" : this.getTypeDeclaration(inner));
        } else if (propertySchema instanceof BooleanSchema) {
            out = String.valueOf(((BooleanSchema)propertySchema).getDefault());
        } else if (propertySchema instanceof IntegerSchema && "int64".equals(propertySchema.getFormat())) {
            Long def = propertySchema.getDefault() != null ? Long.valueOf(propertySchema.getDefault().toString()) : null;
            out = def == null ? out : def.toString() + "L";
        } else if (propertySchema instanceof MapSchema) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            String s = inner == null ? "Object" : this.getTypeDeclaration(inner);
            out = String.format("new Map<String, %s>()", s);
        } else if (propertySchema instanceof StringSchema) {
            StringSchema schema = (StringSchema)propertySchema;
            String def = (String)schema.getDefault();
            if (def != null) {
                out = schema.getEnum() == null ? String.format("'%s'", this.escapeText(def)) : def;
            }
        } else {
            out = super.toDefaultValue(propertySchema);
        }
        return "null".equals(out) ? null : out;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter parameter) {
        if (ExtensionHelper.getBooleanValue(parameter, "x-is-long")) {
            parameter.example = "2147483648L";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-file")) {
            parameter.example = "Blob.valueOf('Sample text file\\nContents')";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-date")) {
            parameter.example = "Date.newInstance(1960, 2, 17)";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-date-time")) {
            parameter.example = "Datetime.newInstanceGmt(2013, 11, 12, 3, 3, 3)";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-list-container")) {
            parameter.example = "new " + parameter.dataType + "{" + parameter.items.example + "}";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-map-container")) {
            parameter.example = "new " + parameter.dataType + "{" + parameter.items.example + "}";
        } else if (ExtensionHelper.getBooleanValue(parameter, "x-is-string")) {
            parameter.example = "'" + parameter.example + "'";
        } else if ("".equals(parameter.example) || parameter.example == null) {
            parameter.example = parameter.dataType + ".getExample()";
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel cm = super.fromModel(name, schema, allSchemas);
        if (cm.interfaces == null) {
            cm.interfaces = new ArrayList<String>();
        }
        Boolean hasDefaultValues = false;
        ArrayList propertyMappings = new ArrayList();
        for (CodegenProperty p : cm.allVars) {
            hasDefaultValues = hasDefaultValues | p.defaultValue != null;
            if (p.baseName.equals(p.name)) continue;
            HashMap<String, String> mapping = new HashMap<String, String>();
            mapping.put("externalName", p.baseName);
            mapping.put("internalName", p.name);
            propertyMappings.add(mapping);
        }
        if (cm.vendorExtensions == null) {
            cm.vendorExtensions = new HashMap<String, Object>();
        }
        cm.vendorExtensions.put("hasPropertyMappings", !propertyMappings.isEmpty());
        cm.vendorExtensions.put("hasDefaultValues", hasDefaultValues);
        cm.vendorExtensions.put("propertyMappings", propertyMappings);
        if (!propertyMappings.isEmpty()) {
            cm.interfaces.add("Swagger.MappedProperties");
        }
        return cm;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        if (ExtensionHelper.getBooleanValue(parameter, "x-is-body-param") && ExtensionHelper.getBooleanValue(parameter, "x-is-list-container")) {
            parameter.items = parameter.items.items;
            this.setParameterExampleValue(parameter);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        String calloutLabel = info.getTitle();
        this.additionalProperties.put("calloutLabel", calloutLabel);
        String sanitized = this.sanitizeName(calloutLabel);
        this.additionalProperties.put("calloutName", sanitized);
        this.supportingFiles.add(new SupportingFile("namedCredential.mustache", this.srcPath + "/namedCredentials", sanitized + ".namedCredential"));
        if (this.additionalProperties.get(BUILD_METHOD).equals("sfdx")) {
            this.generateSfdxSupportingFiles();
        } else if (this.additionalProperties.get(BUILD_METHOD).equals("ant")) {
            this.generateAntSupportingFiles();
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI openAPI) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, openAPI);
        if (op.getHasExamples()) {
            ApiResponse responseProperty = this.findMethodResponse(operation.getResponses());
            String deserializedExample = this.toExampleValue(this.getSchemaFromResponse(responseProperty));
            for (Map<String, String> example : op.examples) {
                example.put("example", this.escapeText(example.get("example")));
                example.put("deserializedExample", deserializedExample);
            }
        }
        return op;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "\\'");
    }

    public void setBuildMethod(String buildMethod) {
        this.srcPath = buildMethod.equals("ant") ? "deploy/" : "src/";
        this.testFolder = this.sourceFolder = this.srcPath;
        this.buildMethod = buildMethod;
    }

    public void setNamedCredential(String namedCredential) {
        this.namedCredential = namedCredential;
    }

    public void setClassPrefix(String classPrefix) {
        this.modelNamePrefix = classPrefix;
        this.classPrefix = classPrefix;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    private String toApiVersion(String apiVersion) {
        if (apiVersion.matches("^\\d{2}(\\.0)?$")) {
            return apiVersion.substring(0, 2) + ".0";
        }
        LOGGER.warn(String.format("specified API version is invalid: %s - defaulting to %s", apiVersion, this.apiVersion));
        return this.apiVersion;
    }

    private void postProcessOpts() {
        this.supportingFiles.add(new SupportingFile("client.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls-meta.xml"));
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return input.replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toExampleValue(Schema propertySchema) {
        String example;
        if (propertySchema == null) {
            return "";
        }
        Object obj = propertySchema.getExample();
        String string = example = obj == null ? "" : obj.toString();
        if (propertySchema instanceof ArraySchema) {
            example = String.format("new %s {%s}", this.getTypeDeclaration(propertySchema), this.toExampleValue(((ArraySchema)propertySchema).getItems()));
        } else if (propertySchema instanceof BooleanSchema) {
            example = String.valueOf(!"false".equals(example));
        } else if (propertySchema instanceof ByteArraySchema) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
            }
            propertySchema.setExample((Object)example);
            example = String.format("EncodingUtil.base64Decode('%s')", example);
        } else if (propertySchema instanceof DateSchema) {
            if (propertySchema.getExample() != null) {
                example = DateFormatUtils.format((Date)((Date)propertySchema.getExample()), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern());
                if (example.matches("^\\d{4}(-\\d{2}){2}")) {
                    example = example.substring(0, 10).replaceAll("-0?", ", ");
                } else if (example.isEmpty()) {
                    example = "2000, 1, 23";
                } else {
                    LOGGER.warn(String.format("The example provided for property '%s' is not a valid RFC3339 date. Defaulting to '2000-01-23'. [%s]", propertySchema.getName(), example));
                    example = "2000, 1, 23";
                }
            } else {
                example = "2000, 1, 23";
            }
            example = String.format("Date.newInstance(%s)", example);
        } else if (propertySchema instanceof DateTimeSchema) {
            if (propertySchema.getExample() != null) {
                example = DateFormatUtils.format((Date)((Date)propertySchema.getExample()), (String)"yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
                if (example.matches("^\\d{4}([-T:]\\d{2}){5}.+")) {
                    example = example.substring(0, 19).replaceAll("[-T:]0?", ", ");
                } else if (example.isEmpty()) {
                    example = "2000, 1, 23, 4, 56, 7";
                } else {
                    LOGGER.warn(String.format("The example provided for property '%s' is not a valid RFC3339 datetime. Defaulting to '2000-01-23T04-56-07Z'. [%s]", propertySchema.getName(), example));
                    example = "2000, 1, 23, 4, 56, 7";
                }
            } else {
                example = "2000, 1, 23, 4, 56, 7";
            }
            example = String.format("Datetime.newInstanceGmt(%s)", example);
        } else if (propertySchema instanceof NumberSchema) {
            example = (example = example.replaceAll("[^-0-9.]", "")).isEmpty() ? "1.3579" : example;
        } else if (propertySchema instanceof FileSchema) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
                propertySchema.setExample((Object)example);
            }
            example = String.format("EncodingUtil.base64Decode(%s)", example);
        } else if (propertySchema instanceof EmailSchema) {
            if (example.isEmpty()) {
                example = "example@example.com";
                ((EmailSchema)propertySchema).setExample((Object)example);
            }
            example = "'" + example + "'";
        } else if (propertySchema instanceof IntegerSchema && "int64".equals(propertySchema.getFormat())) {
            example = example.isEmpty() ? "123456789L" : example + "L";
        } else if (propertySchema instanceof MapSchema && ApexClientCodegen.hasSchemaProperties(propertySchema)) {
            example = String.format("new %s {'key'=>%s}", this.getTypeDeclaration(propertySchema), this.toExampleValue((Schema)propertySchema.getAdditionalProperties()));
        } else if (propertySchema instanceof ObjectSchema) {
            example = example.isEmpty() ? "null" : example;
        } else if (propertySchema instanceof PasswordSchema) {
            example = example.isEmpty() ? "password123" : this.escapeText(example);
            propertySchema.setExample((Object)example);
            example = String.format("'%s'", example);
        } else if (StringUtils.isNotBlank((CharSequence)propertySchema.get$ref())) {
            example = this.getTypeDeclaration(propertySchema) + ".getExample()";
        } else if (propertySchema instanceof StringSchema) {
            List enums = propertySchema.getEnum();
            if (enums != null && example.isEmpty()) {
                example = (String)enums.get(0);
                propertySchema.setExample((Object)example);
            } else if (example.isEmpty()) {
                example = "aeiou";
            } else {
                example = this.escapeText(example);
                propertySchema.setExample((Object)example);
            }
            example = "'" + example + "'";
        } else if (propertySchema instanceof UUIDSchema) {
            example = example.isEmpty() ? "'046b6c7f-0b8a-43b9-b35d-6489e6daee91'" : String.format("'%s'", this.escapeText(example));
        } else if (propertySchema instanceof IntegerSchema) {
            example = example.matches("^-?\\d+$") ? example : "123";
        }
        return example;
    }

    @Override
    public String toApiName(String name) {
        return ApexClientCodegen.camelize(this.classPrefix + super.toApiName(name));
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        ModelUtils.updateCodegenPropertyEnum(var);
        boolean isEnum = ExtensionHelper.getBooleanValue(var, "x-is-enum");
        if (isEnum && var.example != null) {
            String example = var.example.replace("'", "");
            example = this.toEnumVarName(example, var.datatype);
            var.example = this.toEnumDefaultValue(example, var.datatypeWithEnum);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "apex";
    }

    @Override
    public String getHelp() {
        return "Generates an Apex API client library (beta).";
    }

    private void generateAntSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("package.mustache", "deploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "undeploy", "destructiveChanges.xml"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "build.xml"));
        this.supportingFiles.add(new SupportingFile("build.properties", "build.properties"));
        this.supportingFiles.add(new SupportingFile("remove.package.mustache", "undeploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.writeOptional(this.outputFolder, new SupportingFile("README_ant.mustache", "README.md"));
    }

    private void generateSfdxSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("sfdx.mustache", "", "sfdx-oss-manifest.json"));
        this.writeOptional(this.outputFolder, new SupportingFile("README_sfdx.mustache", "README.md"));
    }
}

