/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import io.swagger.annotations.Extension;
import io.swagger.annotations.OAuth2Definition;
import io.swagger.annotations.ResponseHeader;
import io.swagger.annotations.Scope;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jaxrs.utils.ReaderUtils;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    private static final String SUCCESSFUL_OPERATION = "successful operation";
    private static final String PATH_DELIMITER = "/";
    private final ReaderConfig config;
    private Swagger swagger;

    public Reader(Swagger swagger) {
        this(swagger, null);
    }

    public Reader(Swagger swagger, ReaderConfig config) {
        this.swagger = swagger == null ? new Swagger() : swagger;
        this.config = new DefaultReaderConfig(config);
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                if (class1.equals(class2)) {
                    return 0;
                }
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
                return class1.getName().compareTo(class2.getName());
            }
        });
        sortedClasses.addAll(classes);
        HashMap<Class, ReaderListener> listeners = new HashMap<Class, ReaderListener>();
        for (Class clazz : sortedClasses) {
            if (!ReaderListener.class.isAssignableFrom(clazz) || listeners.containsKey(clazz)) continue;
            try {
                listeners.put(clazz, (ReaderListener)clazz.newInstance());
            }
            catch (Exception e) {
                LOGGER.error("Failed to create ReaderListener", (Throwable)e);
            }
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.beforeScan(this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking beforeScan listener [" + readerListener.getClass().getName() + "]", (Throwable)e);
            }
        }
        for (Class clazz : sortedClasses) {
            SwaggerDefinition swaggerDefinition = clazz.getAnnotation(SwaggerDefinition.class);
            if (swaggerDefinition == null) continue;
            this.readSwaggerConfig(clazz, swaggerDefinition);
        }
        for (Class clazz : sortedClasses) {
            this.read(clazz, "", null, false, new String[0], new String[0], new LinkedHashMap<String, Tag>(), new ArrayList<Parameter>(), new HashSet());
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.afterScan(this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking afterScan listener [" + readerListener.getClass().getName() + "]", (Throwable)e);
            }
        }
        return this.swagger;
    }

    public Swagger read(Class<?> cls) {
        SwaggerDefinition swaggerDefinition = cls.getAnnotation(SwaggerDefinition.class);
        if (swaggerDefinition != null) {
            this.readSwaggerConfig(cls, swaggerDefinition);
        }
        return this.read(cls, "", null, false, new String[0], new String[0], new LinkedHashMap<String, Tag>(), new ArrayList<Parameter>(), new HashSet());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        return this.read(cls, parentPath, parentMethod, isSubresource, parentConsumes, parentProduces, parentTags, parentParameters, new HashSet());
    }

    private Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters, Set<Class<?>> scannedResources) {
        boolean readable;
        LinkedHashMap<String, Tag> tags = new LinkedHashMap<String, Tag>();
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        String[] consumes = new String[]{};
        String[] produces = new String[]{};
        EnumSet<Scheme> globalSchemes = EnumSet.noneOf(Scheme.class);
        Api api = (Api)ReflectionUtils.getAnnotation(cls, Api.class);
        boolean hasPathAnnotation = ReflectionUtils.getAnnotation(cls, Path.class) != null;
        boolean hasApiAnnotation = api != null;
        boolean isApiHidden = hasApiAnnotation && api.hidden();
        boolean classReadable = (hasPathAnnotation && hasApiAnnotation || isSubresource) && !isApiHidden;
        boolean scanAll = !isApiHidden && this.config.isScanAllResources() && (hasPathAnnotation || isSubresource);
        boolean bl = readable = classReadable || scanAll;
        if (!readable) {
            return this.swagger;
        }
        boolean apiReadable = hasApiAnnotation;
        if (apiReadable) {
            Set<String> tagStrings = this.extractTags(api);
            for (String tagString : tagStrings) {
                Tag tag = new Tag().name(tagString);
                tags.put(tagString, tag);
            }
            for (String tagName : tags.keySet()) {
                this.swagger.tag((Tag)tags.get(tagName));
            }
            if (!api.produces().isEmpty()) {
                produces = ReaderUtils.splitContentValues(new String[]{api.produces()});
            }
            if (!api.consumes().isEmpty()) {
                consumes = ReaderUtils.splitContentValues(new String[]{api.consumes()});
            }
            globalSchemes.addAll(Reader.parseSchemes(api.protocols()));
            for (Iterator<String> iterator : api.authorizations()) {
                if (iterator.value() == null || iterator.value().isEmpty()) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(iterator.value());
                for (AuthorizationScope scope : iterator.scopes()) {
                    if (scope.scope() == null || scope.scope().isEmpty()) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
        }
        if (readable) {
            Method[] methods;
            if (isSubresource && parentTags != null) {
                tags.putAll(parentTags);
            }
            if (consumes.length == 0 && cls.getAnnotation(Consumes.class) != null) {
                consumes = ReaderUtils.splitContentValues(cls.getAnnotation(Consumes.class).value());
            }
            if (produces.length == 0 && cls.getAnnotation(Produces.class) != null) {
                produces = ReaderUtils.splitContentValues(cls.getAnnotation(Produces.class).value());
            }
            ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
            globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.swagger));
            globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.swagger));
            ApiResponses classResponseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation(cls, ApiResponses.class);
            ArrayList<ApiResponse> classApiResponses = new ArrayList<ApiResponse>();
            if (classResponseAnnotation != null) {
                classApiResponses.addAll(Arrays.asList(classResponseAnnotation.value()));
            }
            Path apiPath = (Path)ReflectionUtils.getAnnotation(cls, Path.class);
            JavaType javaType = TypeFactory.defaultInstance().constructType(cls);
            BeanDescription bd = new ObjectMapper().getSerializationConfig().introspect(javaType);
            for (Method method : methods = cls.getMethods()) {
                io.swagger.models.Path path;
                Class<?> subResource;
                AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), (Class[])method.getParameterTypes());
                if (ReflectionUtils.isOverriddenMethod((Method)method, cls)) continue;
                Path methodPath = (Path)ReflectionUtils.getAnnotation((Method)method, Path.class);
                String operationPath = this.getPath(apiPath, methodPath, parentPath, isSubresource);
                LinkedHashMap regexMap = new LinkedHashMap();
                if ((operationPath = PathUtils.parsePath((String)operationPath, regexMap)) == null || this.isIgnored(operationPath)) continue;
                ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
                String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
                Operation operation = null;
                if (apiOperation != null || this.config.isScanAllResources() || httpMethod != null || methodPath != null) {
                    operation = this.parseMethod(cls, method, annotatedMethod, globalParameters, classApiResponses);
                }
                if (operation == null) continue;
                if (parentParameters != null) {
                    for (Parameter param : parentParameters) {
                        operation.parameter(param);
                    }
                }
                for (Parameter param : operation.getParameters()) {
                    if (regexMap.get(param.getName()) == null) continue;
                    String pattern = (String)regexMap.get(param.getName());
                    param.setPattern(pattern);
                }
                if (apiOperation != null) {
                    for (Scheme scheme : Reader.parseSchemes(apiOperation.protocols())) {
                        operation.scheme(scheme);
                    }
                }
                if (operation.getSchemes() == null || operation.getSchemes().isEmpty()) {
                    for (Scheme scheme : globalSchemes) {
                        operation.scheme(scheme);
                    }
                }
                String[] apiConsumes = consumes;
                if (parentConsumes != null) {
                    LinkedHashSet<String> both = new LinkedHashSet<String>(Arrays.asList(apiConsumes));
                    both.addAll(new LinkedHashSet<String>(Arrays.asList(parentConsumes)));
                    if (operation.getConsumes() != null) {
                        both.addAll(new LinkedHashSet(operation.getConsumes()));
                    }
                    apiConsumes = both.toArray(new String[both.size()]);
                }
                String[] apiProduces = produces;
                if (parentProduces != null) {
                    LinkedHashSet<String> both = new LinkedHashSet<String>(Arrays.asList(apiProduces));
                    both.addAll(new LinkedHashSet<String>(Arrays.asList(parentProduces)));
                    if (operation.getProduces() != null) {
                        both.addAll(new LinkedHashSet(operation.getProduces()));
                    }
                    apiProduces = both.toArray(new String[both.size()]);
                }
                if ((subResource = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method)) != null && !scannedResources.contains(subResource)) {
                    scannedResources.add(subResource);
                    this.read(subResource, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters(), scannedResources);
                    scannedResources.remove(subResource);
                }
                String string = httpMethod = httpMethod == null ? parentMethod : httpMethod;
                if (httpMethod == null) continue;
                if (apiOperation != null) {
                    for (String string2 : apiOperation.tags()) {
                        if ("".equals(string2)) continue;
                        operation.tag(string2);
                        this.swagger.tag(new Tag().name(string2));
                    }
                    operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions()));
                }
                if (operation.getConsumes() == null) {
                    for (String string3 : apiConsumes) {
                        operation.consumes(string3);
                    }
                }
                if (operation.getProduces() == null) {
                    for (String string4 : apiProduces) {
                        operation.produces(string4);
                    }
                }
                if (operation.getTags() == null) {
                    for (String tagString : tags.keySet()) {
                        operation.tag(tagString);
                    }
                }
                if (operation.getSecurity() == null) {
                    for (SecurityRequirement security : securities) {
                        operation.security(security);
                    }
                }
                if ((path = this.swagger.getPath(operationPath)) == null) {
                    path = new io.swagger.models.Path();
                    this.swagger.path(operationPath, path);
                }
                path.set(httpMethod, operation);
                this.readImplicitParameters(method, operation);
                this.readExternalDocs(method, operation);
            }
        }
        return this.swagger;
    }

    private void readImplicitParameters(Method method, Operation operation) {
        this.processImplicitParams((ApiImplicitParams)ReflectionUtils.getAnnotation((Method)method, ApiImplicitParams.class), operation);
        this.processImplicitParams((ApiImplicitParams)ReflectionUtils.getAnnotation(method.getDeclaringClass(), ApiImplicitParams.class), operation);
    }

    private void processImplicitParams(ApiImplicitParams implicitParams, Operation operation) {
        if (implicitParams != null) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Parameter p = this.readImplicitParam(param);
                if (p == null) continue;
                operation.addParameter(p);
            }
        }
    }

    private void readExternalDocs(Method method, Operation operation) {
        io.swagger.annotations.ExternalDocs externalDocs = (io.swagger.annotations.ExternalDocs)ReflectionUtils.getAnnotation((Method)method, io.swagger.annotations.ExternalDocs.class);
        if (externalDocs != null) {
            operation.setExternalDocs(new ExternalDocs(externalDocs.value(), externalDocs.url()));
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam param) {
        Type type;
        PathParameter p;
        if (param.paramType().equalsIgnoreCase("path")) {
            p = new PathParameter();
        } else if (param.paramType().equalsIgnoreCase("query")) {
            p = new QueryParameter();
        } else if (param.paramType().equalsIgnoreCase("form") || param.paramType().equalsIgnoreCase("formData")) {
            p = new FormParameter();
        } else if (param.paramType().equalsIgnoreCase("body")) {
            p = null;
        } else if (param.paramType().equalsIgnoreCase("header")) {
            p = new HeaderParameter();
        } else {
            LOGGER.warn("Unknown implicit parameter type: [{}]", (Object)param.paramType());
            return null;
        }
        Type type2 = type = param.dataTypeClass() == Void.class ? ReflectionUtils.typeFromString((String)param.dataType()) : param.dataTypeClass();
        if (type == null) {
            LOGGER.error("no dataType defined for implicit param `{}`! resolved parameter will not have a type defined, and will therefore be not compliant with spec. see https://github.com/swagger-api/swagger-core/issues/2556.", (Object)param.name());
        }
        return ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)p, (Type)(type == null ? String.class : type), Arrays.asList(param));
    }

    /*
     * WARNING - void declaration
     */
    protected void readSwaggerConfig(Class<?> cls, SwaggerDefinition config) {
        int n;
        if (!config.basePath().isEmpty()) {
            this.swagger.setBasePath(config.basePath());
        }
        if (!config.host().isEmpty()) {
            this.swagger.setHost(config.host());
        }
        this.readInfoConfig(config);
        for (String string : config.consumes()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : config.produces()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        for (String string : config.securityDefinition().oAuth2Definitions()) {
            void var7_19;
            OAuth2Definition oAuth2Definition = new OAuth2Definition();
            OAuth2Definition.Flow flow = string.flow();
            if (flow.equals((Object)OAuth2Definition.Flow.ACCESS_CODE)) {
                OAuth2Definition oAuth2Definition2 = oAuth2Definition.accessCode(string.authorizationUrl(), string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.APPLICATION)) {
                OAuth2Definition oAuth2Definition3 = oAuth2Definition.application(string.tokenUrl());
            } else if (flow.equals((Object)OAuth2Definition.Flow.IMPLICIT)) {
                OAuth2Definition oAuth2Definition4 = oAuth2Definition.implicit(string.authorizationUrl());
            } else {
                OAuth2Definition oAuth2Definition5 = oAuth2Definition.password(string.tokenUrl());
            }
            for (Scope scope : string.scopes()) {
                var7_19.addScope(scope.name(), scope.description());
            }
            var7_19.setDescription(string.description());
            this.swagger.addSecurityDefinition(string.key(), (SecuritySchemeDefinition)var7_19);
        }
        String[] stringArray = new ApiKeyAuthDefinition[][]{config.securityDefinition().apiKeyAuthDefintions(), config.securityDefinition().apiKeyAuthDefinitions()};
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String apiKeyAuthConfig : string = stringArray[n]) {
                io.swagger.models.auth.ApiKeyAuthDefinition apiKeyAuthDefinition = new io.swagger.models.auth.ApiKeyAuthDefinition();
                apiKeyAuthDefinition.setName(apiKeyAuthConfig.name());
                apiKeyAuthDefinition.setIn(In.forValue((String)apiKeyAuthConfig.in().toValue()));
                apiKeyAuthDefinition.setDescription(apiKeyAuthConfig.description());
                this.swagger.addSecurityDefinition(apiKeyAuthConfig.key(), (SecuritySchemeDefinition)apiKeyAuthDefinition);
            }
        }
        stringArray = new io.swagger.annotations.BasicAuthDefinition[][]{config.securityDefinition().basicAuthDefinions(), config.securityDefinition().basicAuthDefinitions()};
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string;
            for (String basicAuthConfig : string = stringArray[n]) {
                BasicAuthDefinition basicAuthDefinition = new BasicAuthDefinition();
                basicAuthDefinition.setDescription(basicAuthConfig.description());
                this.swagger.addSecurityDefinition(basicAuthConfig.key(), (SecuritySchemeDefinition)basicAuthDefinition);
            }
        }
        if (!config.externalDocs().value().isEmpty()) {
            ExternalDocs externalDocs = this.swagger.getExternalDocs();
            if (externalDocs == null) {
                externalDocs = new ExternalDocs();
                this.swagger.setExternalDocs(externalDocs);
            }
            externalDocs.setDescription(config.externalDocs().value());
            if (!config.externalDocs().url().isEmpty()) {
                externalDocs.setUrl(config.externalDocs().url());
            }
        }
        for (String string : config.tags()) {
            if (string.name().isEmpty()) continue;
            Tag tag = new Tag();
            tag.setName(string.name());
            tag.setDescription(string.description());
            if (!string.externalDocs().value().isEmpty()) {
                tag.setExternalDocs(new ExternalDocs(string.externalDocs().value(), string.externalDocs().url()));
            }
            tag.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])string.extensions()));
            this.swagger.addTag(tag);
        }
        for (String string : config.schemes()) {
            if (string == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)string.name()));
        }
    }

    protected void readInfoConfig(SwaggerDefinition config) {
        io.swagger.annotations.Info infoConfig = config.info();
        Info info = this.swagger.getInfo();
        if (info == null) {
            info = new Info();
            this.swagger.setInfo(info);
        }
        if (!infoConfig.description().isEmpty()) {
            info.setDescription(infoConfig.description());
        }
        if (!infoConfig.termsOfService().isEmpty()) {
            info.setTermsOfService(infoConfig.termsOfService());
        }
        if (!infoConfig.title().isEmpty()) {
            info.setTitle(infoConfig.title());
        }
        if (!infoConfig.version().isEmpty()) {
            info.setVersion(infoConfig.version());
        }
        if (!infoConfig.contact().name().isEmpty()) {
            Contact contact = info.getContact();
            if (contact == null) {
                contact = new Contact();
                info.setContact(contact);
            }
            contact.setName(infoConfig.contact().name());
            if (!infoConfig.contact().email().isEmpty()) {
                contact.setEmail(infoConfig.contact().email());
            }
            if (!infoConfig.contact().url().isEmpty()) {
                contact.setUrl(infoConfig.contact().url());
            }
        }
        if (!infoConfig.license().name().isEmpty()) {
            License license = info.getLicense();
            if (license == null) {
                license = new License();
                info.setLicense(license);
            }
            license.setName(infoConfig.license().name());
            if (!infoConfig.license().url().isEmpty()) {
                license.setUrl(infoConfig.license().url());
            }
        }
        info.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])infoConfig.extensions()));
    }

    protected Class<?> getSubResource(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = Reader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (type.getAnnotation(Api.class) != null) {
            return type;
        }
        for (Method m : type.getMethods()) {
            if (this.extractOperationMethod(null, m, null) == null) continue;
            return type;
        }
        return null;
    }

    protected Class<?> getSubResourceWithJaxRsSubresourceLocatorSpecs(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = Reader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (method.getAnnotation(Path.class) != null && this.extractOperationMethod(null, method, null) == null) {
            return type;
        }
        return null;
    }

    private static Class<?> getClassArgument(Type cls) {
        if (cls instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)cls;
            Type[] args = parameterized.getActualTypeArguments();
            if (args.length != 1) {
                LOGGER.error("Unexpected class definition: {}", (Object)cls);
                return null;
            }
            Type first = args[0];
            if (first instanceof Class) {
                return (Class)first;
            }
            return null;
        }
        LOGGER.error("Unknown class definition: {}", (Object)cls);
        return null;
    }

    protected Set<String> extractTags(Api api) {
        String tagString;
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(tag);
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace(PATH_DELIMITER, ""))) {
            output.add(tagString);
        }
        return output;
    }

    private String getPath(Path classLevelPath, Path methodLevelPath, String parentPath, boolean isSubResource) {
        String output;
        if (classLevelPath == null && methodLevelPath == null && StringUtils.isEmpty((CharSequence)parentPath)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !PATH_DELIMITER.equals(parentPath)) {
            if (!parentPath.startsWith(PATH_DELIMITER)) {
                parentPath = PATH_DELIMITER + parentPath;
            }
            if (parentPath.endsWith(PATH_DELIMITER)) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null && !isSubResource) {
            b.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !PATH_DELIMITER.equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith(PATH_DELIMITER) && !b.toString().endsWith(PATH_DELIMITER)) {
                b.append(PATH_DELIMITER);
            }
            if (methodPath.endsWith(PATH_DELIMITER)) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith(PATH_DELIMITER)) {
            output = PATH_DELIMITER + output;
        }
        if (output.endsWith(PATH_DELIMITER) && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    private Map<String, Property> parseResponseHeaders(ResponseHeader[] headers, JsonView jsonView) {
        LinkedHashMap<String, Property> responseHeaders = null;
        if (headers != null) {
            for (ResponseHeader header : headers) {
                Property property;
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new LinkedHashMap<String, Property>();
                }
                String description = header.description();
                Class cls = header.response();
                if (Reader.isVoid(cls) || (property = ModelConverters.getInstance().readAsProperty((Type)cls, jsonView)) == null) continue;
                Property responseProperty = ContainerWrapper.wrapContainer(header.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
                responseProperty.setDescription(description);
                responseHeaders.put(name, responseProperty);
                this.appendModels(cls);
            }
        }
        return responseHeaders;
    }

    public Operation parseMethod(Method method) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        BeanDescription bd = new ObjectMapper().getSerializationConfig().introspect(classType);
        return this.parseMethod(classType.getClass(), method, bd.findMethod(method.getName(), (Class[])method.getParameterTypes()), Collections.emptyList(), Collections.emptyList());
    }

    private Operation parseMethod(Class<?> cls, Method method, AnnotatedMethod annotatedMethod, List<Parameter> globalParameters, List<ApiResponse> classApiResponses) {
        List<Parameter> parameters;
        JavaType type;
        Produces produces;
        Consumes consumes;
        Property property;
        Operation operation = new Operation();
        if (annotatedMethod != null) {
            method = annotatedMethod.getAnnotated();
        }
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        ApiResponses responseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class);
        String operationId = null;
        boolean methodInSuperType = false;
        if (!cls.isInterface()) {
            boolean bl = methodInSuperType = ReflectionUtils.findMethod((Method)method, cls.getSuperclass()) != null;
        }
        if (!methodInSuperType) {
            for (Class<?> implementedInterface : cls.getInterfaces()) {
                boolean bl = methodInSuperType = ReflectionUtils.findMethod((Method)method, implementedInterface) != null;
                if (methodInSuperType) break;
            }
        }
        operationId = this.getOperationId(method.getName());
        String responseContainer = null;
        Type responseType = null;
        Map<Object, Object> defaultResponseHeaders = new LinkedHashMap();
        JsonView jsonViewAnnotation = (JsonView)ReflectionUtils.getAnnotation((Method)method, JsonView.class);
        if (apiOperation != null) {
            int n;
            if (apiOperation.hidden()) {
                return null;
            }
            if (apiOperation.ignoreJsonView()) {
                jsonViewAnnotation = null;
            }
            if (!apiOperation.nickname().isEmpty()) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders(), jsonViewAnnotation);
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (!Reader.isVoid(apiOperation.response())) {
                responseType = apiOperation.response();
            }
            if (!apiOperation.responseContainer().isEmpty()) {
                responseContainer = apiOperation.responseContainer();
            }
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                if (auth.value().isEmpty()) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : auth.scopes()) {
                    if (scope.scope().isEmpty()) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            for (SecurityRequirement sec : securities) {
                operation.security(sec);
            }
            if (!apiOperation.consumes().isEmpty()) {
                String[] consumesAr;
                String[] sec = consumesAr = ReaderUtils.splitContentValues(new String[]{apiOperation.consumes()});
                n = sec.length;
                for (int auth = 0; auth < n; ++auth) {
                    String consume = sec[auth];
                    operation.consumes(consume);
                }
            }
            if (!apiOperation.produces().isEmpty()) {
                String[] producesAr;
                String[] sec = producesAr = ReaderUtils.splitContentValues(new String[]{apiOperation.produces()});
                n = sec.length;
                for (int auth = 0; auth < n; ++auth) {
                    String produce = sec[auth];
                    operation.produces(produce);
                }
            }
        }
        if (apiOperation != null && StringUtils.isNotEmpty((CharSequence)apiOperation.responseReference())) {
            Response response = new Response().description(SUCCESSFUL_OPERATION);
            response.schema((Property)new RefProperty(apiOperation.responseReference()));
            operation.addResponse(String.valueOf(apiOperation.code()), response);
        } else if (responseType == null) {
            LOGGER.debug("picking up response class from method {}", (Object)method);
            responseType = method.getGenericReturnType();
        }
        if (Reader.isValidResponse(responseType) && (property = ModelConverters.getInstance().readAsProperty(responseType, jsonViewAnnotation)) != null) {
            String[] responseProperty = ContainerWrapper.wrapContainer(responseContainer, property, new ContainerWrapper[0]);
            int responseCode = apiOperation == null ? 200 : apiOperation.code();
            operation.response(responseCode, new Response().description(SUCCESSFUL_OPERATION).schema((Property)responseProperty).headers(defaultResponseHeaders));
            this.appendModelsWithJsonView(responseType, jsonViewAnnotation);
        }
        operation.operationId(operationId);
        if ((operation.getConsumes() == null || operation.getConsumes().isEmpty()) && (consumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class)) != null) {
            for (String mediaType : ReaderUtils.splitContentValues(consumes.value())) {
                operation.consumes(mediaType);
            }
        }
        if ((operation.getProduces() == null || operation.getProduces().isEmpty()) && (produces = (Produces)ReflectionUtils.getAnnotation((Method)method, Produces.class)) != null) {
            for (String mediaType : ReaderUtils.splitContentValues(produces.value())) {
                operation.produces(mediaType);
            }
        }
        ArrayList<ApiResponse> apiResponses = new ArrayList<ApiResponse>();
        if (responseAnnotation != null) {
            apiResponses.addAll(Arrays.asList(responseAnnotation.value()));
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (Class<?> exceptionType : exceptionTypes) {
            ApiResponses exceptionResponses = (ApiResponses)ReflectionUtils.getAnnotation(exceptionType, ApiResponses.class);
            if (exceptionResponses == null) continue;
            apiResponses.addAll(Arrays.asList(exceptionResponses.value()));
        }
        for (ApiResponse apiResponse : apiResponses) {
            this.addResponse(operation, apiResponse, jsonViewAnnotation);
        }
        for (ApiResponse apiResponse : classApiResponses) {
            String key;
            String string = key = apiResponse.code() == 0 ? "default" : String.valueOf(apiResponse.code());
            if (operation.getResponses() != null && operation.getResponses().containsKey(key)) continue;
            this.addResponse(operation, apiResponse, jsonViewAnnotation);
        }
        if (ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null) {
            operation.setDeprecated(Boolean.valueOf(true));
        }
        for (Parameter globalParameter : globalParameters) {
            operation.parameter(globalParameter);
        }
        Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations((Method)method);
        if (annotatedMethod == null) {
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            for (int i = 0; i < genericParameterTypes.length; ++i) {
                type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                parameters = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]));
                for (Parameter parameter : parameters) {
                    operation.parameter(parameter);
                }
            }
        } else {
            for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                AnnotatedParameter param = annotatedMethod.getParameter(i);
                type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                parameters = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]));
                for (Parameter parameter : parameters) {
                    operation.parameter(parameter);
                }
            }
        }
        if (operation.getResponses() == null) {
            Response response = new Response().description(SUCCESSFUL_OPERATION);
            operation.defaultResponse(response);
        }
        this.processOperationDecorator(operation, method);
        return operation;
    }

    private void processOperationDecorator(Operation operation, Method method) {
        Iterator<SwaggerExtension> chain = SwaggerExtensions.chain();
        if (chain.hasNext()) {
            SwaggerExtension extension = chain.next();
            LOGGER.debug("trying to decorate operation: {}", (Object)extension);
            extension.decorateOperation(operation, method, chain);
        }
    }

    private void addResponse(Operation operation, ApiResponse apiResponse, JsonView jsonView) {
        Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders(), jsonView);
        Map<String, Object> examples = this.parseExamples(apiResponse.examples());
        Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
        response.setExamples(examples);
        if (apiResponse.code() == 0) {
            operation.defaultResponse(response);
        } else {
            operation.response(apiResponse.code(), response);
        }
        if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
            response.schema((Property)new RefProperty(apiResponse.reference()));
        } else if (!Reader.isVoid(apiResponse.response())) {
            Class responseType = apiResponse.response();
            Property property = ModelConverters.getInstance().readAsProperty((Type)responseType, jsonView);
            if (property != null) {
                response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), property, new ContainerWrapper[0]));
                this.appendModels(responseType);
            }
        }
    }

    private Map<String, Object> parseExamples(Example examples) {
        if (examples == null) {
            return null;
        }
        LinkedHashMap<String, String> map = null;
        for (ExampleProperty prop : examples.value()) {
            if (prop.mediaType().equals("") && prop.value().equals("")) continue;
            map = map == null ? new LinkedHashMap<String, String>() : map;
            map.put(prop.mediaType(), prop.value());
        }
        return map;
    }

    private List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        Parameter param;
        Iterator<SwaggerExtension> chain = SwaggerExtensions.chain();
        if (!chain.hasNext()) {
            return Collections.emptyList();
        }
        LOGGER.debug("getParameters for {}", (Object)type);
        HashSet<Type> typesToSkip = new HashSet<Type>();
        SwaggerExtension extension = chain.next();
        LOGGER.debug("trying extension {}", (Object)extension);
        List<Parameter> parameters = extension.extractParameters(annotations, type, typesToSkip, chain);
        if (!parameters.isEmpty()) {
            ArrayList<Parameter> processed = new ArrayList<Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                if (ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, (Type)type, annotations) == null) continue;
                processed.add(parameter);
            }
            return processed;
        }
        LOGGER.debug("no parameter found, looking at body params");
        ArrayList<Parameter> body = new ArrayList<Parameter>();
        if (!typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, (Type)type, annotations)) != null) {
            body.add(param);
        }
        return body;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation != null && !"".equals(apiOperation.httpMethod())) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return "options";
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return "head";
        }
        if (method.getAnnotation(PATCH.class) != null) {
            return "patch";
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase();
        }
        if (!StringUtils.isEmpty((CharSequence)this.getHttpMethodFromCustomAnnotations(method))) {
            return this.getHttpMethodFromCustomAnnotations(method);
        }
        if (ReflectionUtils.getOverriddenMethod((Method)method) != null) {
            return this.extractOperationMethod(apiOperation, ReflectionUtils.getOverriddenMethod((Method)method), chain);
        }
        if (chain != null && chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    private String getHttpMethodFromCustomAnnotations(Method method) {
        for (Annotation methodAnnotation : method.getAnnotations()) {
            HttpMethod httpMethod = methodAnnotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return httpMethod.value().toLowerCase();
        }
        return null;
    }

    private static Set<Scheme> parseSchemes(String schemes) {
        EnumSet<Scheme> result = EnumSet.noneOf(Scheme.class);
        for (String item : StringUtils.trimToEmpty((String)schemes).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)item));
            if (scheme == null) continue;
            result.add(scheme);
        }
        return result;
    }

    private void appendModels(Type type) {
        Map models = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : models.entrySet()) {
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private void appendModelsWithJsonView(Type type, JsonView annotation) {
        Map models = ModelConverters.getInstance().readAll(type, annotation);
        for (Map.Entry entry : models.entrySet()) {
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private static boolean isVoid(Type type) {
        Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }

    private boolean isIgnored(String path) {
        for (String item : this.config.getIgnoredRoutes()) {
            int length = item.length();
            if (!path.startsWith(item) || path.length() != length && !path.startsWith(PATH_DELIMITER, length)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidResponse(Type type) {
        if (type == null) {
            return false;
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (Reader.isVoid((Type)javaType)) {
            return false;
        }
        Class cls = javaType.getRawClass();
        return !javax.ws.rs.core.Response.class.isAssignableFrom(cls) && !Reader.isResourceClass(cls);
    }

    private static boolean isResourceClass(Class<?> cls) {
        return cls.getAnnotation(Api.class) != null;
    }

    public ReaderConfig getConfig() {
        return this.config;
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.swagger == null) {
            return false;
        }
        if (this.swagger.getPaths() == null || this.swagger.getPaths().isEmpty()) {
            return false;
        }
        for (io.swagger.models.Path path : this.swagger.getPaths().values()) {
            for (Operation op : path.getOperations()) {
                if (!operationId.equalsIgnoreCase(op.getOperationId())) continue;
                return true;
            }
        }
        return false;
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String container) {
            this.container = container;
        }

        public static Property wrapContainer(String container, Property property, ContainerWrapper ... allowed) {
            EnumSet<ContainerWrapper> tmp = allowed.length > 0 ? EnumSet.copyOf(Arrays.asList(allowed)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper wrapper : tmp) {
                Property prop = wrapper.wrap(container, property);
                if (prop == null) continue;
                return prop;
            }
            return property;
        }

        public Property wrap(String container, Property property) {
            if (this.container.equalsIgnoreCase(container)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }
}

