/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.annotations.Info;
import io.swagger.annotations.ResponseHeader;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.ParameterProcessor;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.config.ReaderListener;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jaxrs.utils.PathUtils;
import io.swagger.jaxrs.utils.ReaderUtils;
import io.swagger.jaxrs.utils.ReflectionUtils;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    private static final String SUCCESSFUL_OPERATION = "successful operation";
    private static final String PATH_DELIMITER = "/";
    private final ReaderConfig config;
    private Swagger swagger;

    public Reader(Swagger swagger) {
        this(swagger, null);
    }

    public Reader(Swagger swagger, ReaderConfig config) {
        this.swagger = swagger == null ? new Swagger() : swagger;
        this.config = new DefaultReaderConfig(config);
    }

    public Swagger read(Set<Class<?>> classes) {
        HashMap listeners = new HashMap();
        for (Class<Object> cls : classes) {
            if (!ReaderListener.class.isAssignableFrom(cls) || listeners.containsKey(cls)) continue;
            try {
                listeners.put(cls, (ReaderListener)cls.newInstance());
            }
            catch (Exception e) {
                LOGGER.error("Failed to create ReaderListener", (Throwable)e);
            }
        }
        for (ReaderListener listener : listeners.values()) {
            try {
                listener.beforeScan(this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking beforeScan listener [" + listener.getClass().getName() + "]", (Throwable)e);
            }
        }
        for (Class<Object> cls : classes) {
            SwaggerDefinition swaggerDefinition = cls.getAnnotation(SwaggerDefinition.class);
            if (swaggerDefinition == null) continue;
            this.readSwaggerConfig(cls, swaggerDefinition);
        }
        for (Class<Object> cls : classes) {
            this.read(cls);
        }
        for (ReaderListener listener : listeners.values()) {
            try {
                listener.afterScan(this, this.swagger);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking afterScan listener [" + listener.getClass().getName() + "]", (Throwable)e);
            }
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class<?> cls) {
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean readHidden, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        boolean readable;
        Api api = cls.getAnnotation(Api.class);
        HashMap globalScopes = new HashMap();
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        String[] consumes = new String[]{};
        String[] produces = new String[]{};
        EnumSet<Scheme> globalSchemes = EnumSet.noneOf(Scheme.class);
        boolean bl = readable = api != null && readHidden || api != null && !api.hidden();
        if (readable) {
            Authorization[] authorizations;
            Set<String> tagStrings = this.extractTags(api);
            for (String tagString : tagStrings) {
                Tag tag = new Tag().name(tagString);
                tags.put(tagString, tag);
            }
            if (parentTags != null) {
                tags.putAll(parentTags);
            }
            for (String tagName : tags.keySet()) {
                this.swagger.tag((Tag)tags.get(tagName));
            }
            if (!api.produces().isEmpty()) {
                produces = new String[]{api.produces()};
            } else if (cls.getAnnotation(Produces.class) != null) {
                produces = cls.getAnnotation(Produces.class).value();
            }
            if (!api.consumes().isEmpty()) {
                consumes = new String[]{api.consumes()};
            } else if (cls.getAnnotation(Consumes.class) != null) {
                consumes = cls.getAnnotation(Consumes.class).value();
            }
            globalSchemes.addAll(Reader.parseSchemes(api.protocols()));
            for (Authorization auth : authorizations = api.authorizations()) {
                AuthorizationScope[] scopes;
                if (auth.value() == null || "".equals(auth.value())) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : scopes = auth.scopes()) {
                    if (scope.scope() == null || "".equals(scope.scope())) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
        }
        if (readable || api == null && this.config.isScanAllResources()) {
            Method[] methods;
            ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
            globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.swagger));
            globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.swagger));
            Path apiPath = cls.getAnnotation(Path.class);
            for (Method method : methods = cls.getMethods()) {
                io.swagger.models.Path path;
                int i$;
                Class<?> subResource;
                if (ReflectionUtils.isOverriddenMethod(method, cls)) continue;
                Path methodPath = Reader.getAnnotation(method, Path.class);
                String operationPath = this.getPath(apiPath, methodPath, parentPath);
                HashMap<String, String> regexMap = new HashMap<String, String>();
                if ((operationPath = PathUtils.parsePath(operationPath, regexMap)) == null || this.isIgnored(operationPath)) continue;
                ApiOperation apiOperation = Reader.getAnnotation(method, ApiOperation.class);
                String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
                Operation operation = null;
                if (apiOperation != null || this.config.isScanAllResources() || httpMethod != null || methodPath != null) {
                    operation = this.parseMethod(method, globalParameters);
                }
                if (operation == null) continue;
                if (parentParameters != null) {
                    for (Parameter param : parentParameters) {
                        operation.parameter(param);
                    }
                }
                for (Parameter param : operation.getParameters()) {
                    if (regexMap.get(param.getName()) == null) continue;
                    String pattern = (String)regexMap.get(param.getName());
                    param.setPattern(pattern);
                }
                if (apiOperation != null) {
                    for (Scheme scheme : Reader.parseSchemes(apiOperation.protocols())) {
                        operation.scheme(scheme);
                    }
                }
                if (operation.getSchemes() == null || operation.getSchemes().isEmpty()) {
                    for (Scheme scheme : globalSchemes) {
                        operation.scheme(scheme);
                    }
                }
                String[] apiConsumes = consumes;
                if (parentConsumes != null) {
                    HashSet<String> both = new HashSet<String>(Arrays.asList(apiConsumes));
                    both.addAll(new HashSet<String>(Arrays.asList(parentConsumes)));
                    if (operation.getConsumes() != null) {
                        both.addAll(new HashSet(operation.getConsumes()));
                    }
                    apiConsumes = both.toArray(new String[both.size()]);
                }
                String[] apiProduces = produces;
                if (parentProduces != null) {
                    HashSet<String> both = new HashSet<String>(Arrays.asList(apiProduces));
                    both.addAll(new HashSet<String>(Arrays.asList(parentProduces)));
                    if (operation.getProduces() != null) {
                        both.addAll(new HashSet(operation.getProduces()));
                    }
                    apiProduces = both.toArray(new String[both.size()]);
                }
                if ((subResource = this.getSubResource(method)) != null) {
                    this.read(subResource, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters());
                }
                String string = httpMethod = httpMethod == null ? parentMethod : httpMethod;
                if (httpMethod == null) continue;
                if (apiOperation != null) {
                    boolean hasExplicitTag = false;
                    for (String tag : apiOperation.tags()) {
                        if ("".equals(tag)) continue;
                        operation.tag(tag);
                        this.swagger.tag(new Tag().name(tag));
                    }
                    if (operation != null) {
                        this.addExtensionProperties(apiOperation.extensions(), operation.getVendorExtensions());
                    }
                }
                if (operation == null) continue;
                if (operation.getConsumes() == null) {
                    String[] arr$ = apiConsumes;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        String mediaType = arr$[i$];
                        operation.consumes(mediaType);
                    }
                }
                if (operation.getProduces() == null) {
                    String[] arr$ = apiProduces;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        String mediaType = arr$[i$];
                        operation.produces(mediaType);
                    }
                }
                if (operation.getTags() == null) {
                    for (String tagString : tags.keySet()) {
                        operation.tag(tagString);
                    }
                }
                if (operation.getSecurity() == null) {
                    for (SecurityRequirement security : securities) {
                        operation.security(security);
                    }
                }
                if ((path = this.swagger.getPath(operationPath)) == null) {
                    path = new io.swagger.models.Path();
                    this.swagger.path(operationPath, path);
                }
                path.set(httpMethod, operation);
                this.readImplicitParameters(method, operation);
            }
        }
        return this.swagger;
    }

    private void readImplicitParameters(Method method, Operation operation) {
        ApiImplicitParams implicitParams = method.getAnnotation(ApiImplicitParams.class);
        if (implicitParams != null && implicitParams.value().length > 0) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Parameter p = this.readImplicitParam(param);
                if (p == null) continue;
                operation.addParameter(p);
            }
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam param) {
        PathParameter p;
        if (param.paramType().equalsIgnoreCase("path")) {
            p = new PathParameter();
        } else if (param.paramType().equalsIgnoreCase("query")) {
            p = new QueryParameter();
        } else if (param.paramType().equalsIgnoreCase("form") || param.paramType().equalsIgnoreCase("formData")) {
            p = new FormParameter();
        } else if (param.paramType().equalsIgnoreCase("body")) {
            p = null;
        } else if (param.paramType().equalsIgnoreCase("header")) {
            p = new HeaderParameter();
        } else {
            LOGGER.warn("Unkown implicit parameter type: [" + param.paramType() + "]");
            return null;
        }
        Type type = ReflectionUtils.typeFromString(param.dataType());
        return ParameterProcessor.applyAnnotations(this.swagger, (Parameter)p, (Type)(type == null ? String.class : type), Arrays.asList(param));
    }

    protected void readSwaggerConfig(Class<?> cls, SwaggerDefinition config) {
        if (!config.basePath().isEmpty()) {
            this.swagger.setBasePath(config.basePath());
        }
        if (!config.host().isEmpty()) {
            this.swagger.setHost(config.host());
        }
        this.readInfoConfig(config);
        for (String string : config.consumes()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addConsumes(string);
        }
        for (String string : config.produces()) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            this.swagger.addProduces(string);
        }
        if (!config.externalDocs().value().isEmpty()) {
            ExternalDocs externalDocs = this.swagger.getExternalDocs();
            if (externalDocs == null) {
                externalDocs = new ExternalDocs();
                this.swagger.setExternalDocs(externalDocs);
            }
            externalDocs.setDescription(config.externalDocs().value());
            if (!config.externalDocs().url().isEmpty()) {
                externalDocs.setUrl(config.externalDocs().url());
            }
        }
        for (String string : config.tags()) {
            if (string.name().isEmpty()) continue;
            Tag tag = new Tag();
            tag.setName(string.name());
            tag.setDescription(string.description());
            if (!string.externalDocs().value().isEmpty()) {
                tag.setExternalDocs(new ExternalDocs(string.externalDocs().value(), string.externalDocs().url()));
            }
            this.addExtensionProperties(string.extensions(), tag.getVendorExtensions());
            this.swagger.addTag(tag);
        }
        for (String string : config.schemes()) {
            if (string == SwaggerDefinition.Scheme.DEFAULT) continue;
            this.swagger.addScheme(Scheme.forValue((String)string.name()));
        }
    }

    protected void readInfoConfig(SwaggerDefinition config) {
        Info infoConfig = config.info();
        io.swagger.models.Info info = this.swagger.getInfo();
        if (info == null) {
            info = new io.swagger.models.Info();
            this.swagger.setInfo(info);
        }
        if (!infoConfig.description().isEmpty()) {
            info.setDescription(infoConfig.description());
        }
        if (!infoConfig.termsOfService().isEmpty()) {
            info.setTermsOfService(infoConfig.termsOfService());
        }
        if (!infoConfig.title().isEmpty()) {
            info.setTitle(infoConfig.title());
        }
        if (!infoConfig.version().isEmpty()) {
            info.setVersion(infoConfig.version());
        }
        if (!infoConfig.contact().name().isEmpty()) {
            Contact contact = info.getContact();
            if (contact == null) {
                contact = new Contact();
                info.setContact(contact);
            }
            contact.setName(infoConfig.contact().name());
            if (!infoConfig.contact().email().isEmpty()) {
                contact.setEmail(infoConfig.contact().email());
            }
            if (!infoConfig.contact().url().isEmpty()) {
                contact.setUrl(infoConfig.contact().url());
            }
        }
        if (!infoConfig.license().name().isEmpty()) {
            License license = info.getLicense();
            if (license == null) {
                license = new License();
                info.setLicense(license);
            }
            license.setName(infoConfig.license().name());
            if (!infoConfig.license().url().isEmpty()) {
                license.setUrl(infoConfig.license().url());
            }
        }
        this.addExtensionProperties(infoConfig.extensions(), info.getVendorExtensions());
    }

    private void addExtensionProperties(Extension[] extensions, Map<String, Object> map) {
        for (Extension extension : extensions) {
            String name = extension.name();
            if (name.length() > 0) {
                if (!name.startsWith("x-")) {
                    name = "x-" + name;
                }
                if (!map.containsKey(name)) {
                    map.put(name, new HashMap());
                }
                map = (Map)map.get(name);
            }
            for (ExtensionProperty property : extension.properties()) {
                if (property.name().isEmpty() || property.value().isEmpty()) continue;
                String propertyName = property.name();
                if (name.isEmpty() && !propertyName.startsWith("x-")) {
                    propertyName = "x-" + propertyName;
                }
                map.put(propertyName, property.value());
            }
        }
    }

    protected Class<?> getSubResource(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = Reader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (type.getAnnotation(Api.class) != null) {
            return type;
        }
        if (this.config.isScanAllResources()) {
            for (Method m : type.getMethods()) {
                if (this.extractOperationMethod(null, m, null) == null) continue;
                return type;
            }
        }
        return null;
    }

    private static Class<?> getClassArgument(Type cls) {
        if (cls instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)cls;
            Type[] args = parameterized.getActualTypeArguments();
            if (args.length != 1) {
                LOGGER.error(String.format("Unexpected class definition: %s", cls));
                return null;
            }
            Type first = args[0];
            if (first instanceof Class) {
                return (Class)first;
            }
            return null;
        }
        LOGGER.error(String.format("Unknown class definition: %s", cls));
        return null;
    }

    protected Set<String> extractTags(Api api) {
        String tagString;
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if ("".equals(tag)) continue;
            hasExplicitTags = true;
            output.add(tag);
        }
        if (!hasExplicitTags && !"".equals(tagString = api.value().replace(PATH_DELIMITER, ""))) {
            output.add(tagString);
        }
        return output;
    }

    String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null && StringUtils.isEmpty((CharSequence)parentPath)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (parentPath != null && !"".equals(parentPath) && !PATH_DELIMITER.equals(parentPath)) {
            if (!parentPath.startsWith(PATH_DELIMITER)) {
                parentPath = PATH_DELIMITER + parentPath;
            }
            if (parentPath.endsWith(PATH_DELIMITER)) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            b.append(parentPath);
        }
        if (classLevelPath != null) {
            b.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !PATH_DELIMITER.equals(methodLevelPath.value())) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith(PATH_DELIMITER) && !b.toString().endsWith(PATH_DELIMITER)) {
                b.append(PATH_DELIMITER);
            }
            if (methodPath.endsWith(PATH_DELIMITER)) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            b.append(methodPath);
        }
        if (!(output = b.toString()).startsWith(PATH_DELIMITER)) {
            output = PATH_DELIMITER + output;
        }
        if (output.endsWith(PATH_DELIMITER) && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    private Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        HashMap<String, Property> responseHeaders = null;
        if (headers != null && headers.length > 0) {
            for (ResponseHeader header : headers) {
                Property property;
                String name = header.name();
                if ("".equals(name)) continue;
                if (responseHeaders == null) {
                    responseHeaders = new HashMap<String, Property>();
                }
                String description = header.description();
                Class cls = header.response();
                if (Reader.isVoid(cls) || (property = ModelConverters.getInstance().readAsProperty((Type)cls)) == null) continue;
                Property responseProperty = ContainerWrapper.wrapContainer(header.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
                responseProperty.setDescription(description);
                responseHeaders.put(name, responseProperty);
                this.appendModels(cls);
            }
        }
        return responseHeaders;
    }

    public Operation parseMethod(Method method) {
        return this.parseMethod(method, Collections.<Parameter>emptyList());
    }

    private Operation parseMethod(Method method, List<Parameter> globalParameters) {
        Consumes annotation;
        Property property;
        Operation operation = new Operation();
        ApiOperation apiOperation = Reader.getAnnotation(method, ApiOperation.class);
        ApiResponses responseAnnotation = Reader.getAnnotation(method, ApiResponses.class);
        String operationId = method.getName();
        String responseContainer = null;
        Type responseType = null;
        Map<Object, Object> defaultResponseHeaders = new HashMap();
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!"".equals(apiOperation.nickname())) {
                operationId = method.getName();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            if (apiOperation.response() != null && !Reader.isVoid(apiOperation.response())) {
                responseType = apiOperation.response();
            }
            if (!"".equals(apiOperation.responseContainer())) {
                responseContainer = apiOperation.responseContainer();
            }
            if (apiOperation.authorizations() != null) {
                ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
                for (Authorization auth : apiOperation.authorizations()) {
                    AuthorizationScope[] scopes;
                    if (auth.value() == null || "".equals(auth.value())) continue;
                    SecurityRequirement security = new SecurityRequirement();
                    security.setName(auth.value());
                    for (AuthorizationScope scope : scopes = auth.scopes()) {
                        if (scope.scope() == null || "".equals(scope.scope())) continue;
                        security.addScope(scope.scope());
                    }
                    securities.add(security);
                }
                if (securities.size() > 0) {
                    for (SecurityRequirement sec : securities) {
                        operation.security(sec);
                    }
                }
            }
            if (apiOperation.consumes() != null && !apiOperation.consumes().isEmpty()) {
                operation.consumes(apiOperation.consumes());
            }
            if (apiOperation.produces() != null && !apiOperation.produces().isEmpty()) {
                operation.produces(apiOperation.produces());
            }
        }
        if (apiOperation != null && StringUtils.isNotEmpty((CharSequence)apiOperation.responseReference())) {
            io.swagger.models.Response response = new io.swagger.models.Response().description(SUCCESSFUL_OPERATION);
            response.schema((Property)new RefProperty(apiOperation.responseReference()));
            operation.addResponse(String.valueOf(apiOperation.code()), response);
        } else if (responseType == null) {
            LOGGER.debug("picking up response class from method " + method);
            responseType = method.getGenericReturnType();
        }
        if (Reader.isValidResponse(responseType) && (property = ModelConverters.getInstance().readAsProperty(responseType)) != null) {
            Property responseProperty = ContainerWrapper.wrapContainer(responseContainer, property, new ContainerWrapper[0]);
            int responseCode = apiOperation == null ? 200 : apiOperation.code();
            operation.response(responseCode, new io.swagger.models.Response().description(SUCCESSFUL_OPERATION).schema(responseProperty).headers(defaultResponseHeaders));
            this.appendModels(responseType);
        }
        operation.operationId(operationId);
        if (apiOperation != null && apiOperation.consumes() != null && apiOperation.consumes().isEmpty() && (annotation = Reader.getAnnotation(method, Consumes.class)) != null) {
            String[] apiConsumes;
            for (String mediaType : apiConsumes = annotation.value()) {
                operation.consumes(mediaType);
            }
        }
        if (apiOperation != null && apiOperation.produces() != null && apiOperation.produces().isEmpty() && (annotation = Reader.getAnnotation(method, Produces.class)) != null) {
            String[] apiProduces;
            for (String mediaType : apiProduces = ((Produces)annotation).value()) {
                operation.produces(mediaType);
            }
        }
        ArrayList apiResponses = new ArrayList();
        if (responseAnnotation != null) {
            for (ApiResponse apiResponse : responseAnnotation.value()) {
                Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
                io.swagger.models.Response response = new io.swagger.models.Response().description(apiResponse.message()).headers(responseHeaders);
                if (apiResponse.code() == 0) {
                    operation.defaultResponse(response);
                } else {
                    operation.response(apiResponse.code(), response);
                }
                if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
                    response.schema((Property)new RefProperty(apiResponse.reference()));
                    continue;
                }
                if (Reader.isVoid(apiResponse.response())) continue;
                responseType = apiResponse.response();
                Property property2 = ModelConverters.getInstance().readAsProperty(responseType);
                if (property2 == null) continue;
                response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), property2, new ContainerWrapper[0]));
                this.appendModels(responseType);
            }
        }
        if (Reader.getAnnotation(method, Deprecated.class) != null) {
            operation.setDeprecated(Boolean.valueOf(true));
        }
        for (Parameter globalParameter : globalParameters) {
            operation.parameter(globalParameter);
        }
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Parameter> parameters = this.getParameters(type, Arrays.asList(paramAnnotations[i]));
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            io.swagger.models.Response response = new io.swagger.models.Response().description(SUCCESSFUL_OPERATION);
            operation.defaultResponse(response);
        }
        return operation;
    }

    private static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        Method superclassMethod;
        A annotation = method.getAnnotation(annotationClass);
        if (annotation == null && (superclassMethod = ReflectionUtils.getOverriddenMethod(method)) != null) {
            annotation = Reader.getAnnotation(superclassMethod, annotationClass);
        }
        return annotation;
    }

    private List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        Parameter param;
        Iterator<SwaggerExtension> chain = SwaggerExtensions.chain();
        if (!chain.hasNext()) {
            return Collections.emptyList();
        }
        LOGGER.debug("getParameters for " + type);
        HashSet<Type> typesToSkip = new HashSet<Type>();
        SwaggerExtension extension = chain.next();
        LOGGER.debug("trying extension " + extension);
        List<Parameter> parameters = extension.extractParameters(annotations, type, typesToSkip, chain);
        if (parameters.size() > 0) {
            ArrayList<Parameter> processed = new ArrayList<Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                if (ParameterProcessor.applyAnnotations(this.swagger, parameter, type, annotations) == null) continue;
                processed.add(parameter);
            }
            return processed;
        }
        LOGGER.debug("no parameter found, looking at body params");
        ArrayList<Parameter> body = new ArrayList<Parameter>();
        if (!typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations(this.swagger, null, type, annotations)) != null) {
            body.add(param);
        }
        return body;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation != null && apiOperation.httpMethod() != null && !"".equals(apiOperation.httpMethod())) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (method.getAnnotation(GET.class) != null) {
            return "get";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "put";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "post";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "delete";
        }
        if (method.getAnnotation(OPTIONS.class) != null) {
            return "options";
        }
        if (method.getAnnotation(HEAD.class) != null) {
            return "head";
        }
        if (method.getAnnotation(PATCH.class) != null) {
            return "patch";
        }
        if (method.getAnnotation(HttpMethod.class) != null) {
            HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
            return httpMethod.value().toLowerCase();
        }
        if (ReflectionUtils.getOverriddenMethod(method) != null) {
            return this.extractOperationMethod(apiOperation, ReflectionUtils.getOverriddenMethod(method), chain);
        }
        if (chain != null && chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    private static Set<Scheme> parseSchemes(String schemes) {
        EnumSet<Scheme> result = EnumSet.noneOf(Scheme.class);
        for (String item : StringUtils.trimToEmpty((String)schemes).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)item));
            if (scheme == null) continue;
            result.add(scheme);
        }
        return result;
    }

    private void appendModels(Type type) {
        Map models = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : models.entrySet()) {
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private static boolean isVoid(Type type) {
        Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }

    private boolean isIgnored(String path) {
        for (String item : this.config.getIgnoredRoutes()) {
            int length = item.length();
            if (!path.startsWith(item) || path.length() != length && !path.startsWith(PATH_DELIMITER, length)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidResponse(Type type) {
        if (type == null) {
            return false;
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (Reader.isVoid((Type)javaType)) {
            return false;
        }
        Class cls = javaType.getRawClass();
        return !Response.class.isAssignableFrom(cls) && !Reader.isResourceClass(cls);
    }

    private static boolean isResourceClass(Class<?> cls) {
        return cls.getAnnotation(Api.class) != null;
    }

    public ReaderConfig getConfig() {
        return this.config;
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String container) {
            this.container = container;
        }

        public static Property wrapContainer(String container, Property property, ContainerWrapper ... allowed) {
            EnumSet<ContainerWrapper> tmp = allowed.length > 0 ? EnumSet.copyOf(Arrays.asList(allowed)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper wrapper : tmp) {
                Property prop = wrapper.wrap(container, property);
                if (prop == null) continue;
                return prop;
            }
            return property;
        }

        public Property wrap(String container, Property property) {
            if (this.container.equalsIgnoreCase(container)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }
}

