/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs2.util.ReaderUtils;
import io.swagger.oas.annotations.Parameter;
import io.swagger.oas.annotations.enums.Explode;
import io.swagger.oas.annotations.info.Contact;
import io.swagger.oas.annotations.info.Info;
import io.swagger.oas.annotations.info.License;
import io.swagger.oas.annotations.links.Link;
import io.swagger.oas.annotations.links.LinkParameters;
import io.swagger.oas.annotations.media.Content;
import io.swagger.oas.annotations.media.ExampleObject;
import io.swagger.oas.annotations.media.Schema;
import io.swagger.oas.annotations.parameters.RequestBody;
import io.swagger.oas.annotations.responses.ApiResponse;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.ExternalDocumentation;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.servers.ServerVariable;
import io.swagger.oas.models.servers.ServerVariables;
import io.swagger.oas.models.tags.Tag;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;

public class OperationParser {
    public static final String RESPONSE_DEFAULT = "default";
    public static final String MEDIA_TYPE = "*/*";
    public static final String COMPONENTS_REF = "#/components/schemas/";
    public static final String DEFAULT_DESCRIPTION = "no description";

    public static Optional<List<io.swagger.oas.models.parameters.Parameter>> getParametersList(Parameter[] parameters, Components components) {
        if (parameters == null) {
            return Optional.empty();
        }
        ArrayList parametersObject = new ArrayList();
        for (Parameter parameter : parameters) {
            OperationParser.getParameter(parameter, components).ifPresent(parametersObject::add);
        }
        if (parametersObject.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(parametersObject);
    }

    public static Optional<io.swagger.oas.models.parameters.Parameter> getParameter(Parameter parameter, Components components) {
        if (parameter == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.parameters.Parameter parameterObject = new io.swagger.oas.models.parameters.Parameter();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)parameter.description())) {
            parameterObject.setDescription(parameter.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)parameter.name())) {
            parameterObject.setName(parameter.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)parameter.in())) {
            parameterObject.setIn(parameter.in());
            isEmpty = false;
        }
        if (parameter.deprecated()) {
            parameterObject.setDeprecated(Boolean.valueOf(parameter.deprecated()));
        }
        if (parameter.required()) {
            parameterObject.setRequired(Boolean.valueOf(parameter.required()));
            isEmpty = false;
        }
        if (parameter.allowEmptyValue()) {
            parameterObject.setAllowEmptyValue(Boolean.valueOf(parameter.allowEmptyValue()));
            isEmpty = false;
        }
        if (parameter.allowReserved()) {
            parameterObject.setAllowReserved(Boolean.valueOf(parameter.allowReserved()));
            isEmpty = false;
        }
        ParameterProcessor.setParameterStyle((io.swagger.oas.models.parameters.Parameter)parameterObject, (Parameter)parameter);
        ParameterProcessor.setParameterExplode((io.swagger.oas.models.parameters.Parameter)parameterObject, (Parameter)parameter);
        if (!Explode.DEFAULT.equals((Object)parameter.explode())) {
            isEmpty = false;
        }
        if (parameter.schema() != null && parameter.schema().implementation() == Void.class) {
            OperationParser.getSchemaFromAnnotation(parameter.schema()).ifPresent(schema -> {
                if (StringUtils.isNotBlank((CharSequence)schema.getType())) {
                    parameterObject.setSchema(schema);
                    components.addSchemas(schema.getType(), schema);
                }
            });
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContents(parameter.content(), components).ifPresent(arg_0 -> ((io.swagger.oas.models.parameters.Parameter)parameterObject).setContent(arg_0));
        return Optional.of(parameterObject);
    }

    public static Optional<io.swagger.oas.models.media.Schema> getSchemaFromAnnotation(Schema schema) {
        if (schema == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.media.Schema schemaObject = new io.swagger.oas.models.media.Schema();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)schema.description())) {
            schemaObject.setDescription(schema.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.ref())) {
            schemaObject.set$ref(schema.ref());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.type())) {
            schemaObject.setType(schema.type());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema._default())) {
            schemaObject.setDefault((Object)schema._default());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.example())) {
            schemaObject.setExample((Object)schema.example());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.format())) {
            schemaObject.setFormat(schema.format());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.example())) {
            schemaObject.setExample((Object)schema.example());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            schemaObject.setPattern(schema.pattern());
            isEmpty = false;
        }
        if (schema.readOnly()) {
            schemaObject.setReadOnly(Boolean.valueOf(schema.readOnly()));
            isEmpty = false;
        }
        if (schema.deprecated()) {
            schemaObject.setDeprecated(Boolean.valueOf(schema.deprecated()));
            isEmpty = false;
        }
        if (schema.exclusiveMaximum()) {
            schemaObject.setExclusiveMaximum(Boolean.valueOf(schema.exclusiveMaximum()));
            isEmpty = false;
        }
        if (schema.exclusiveMinimum()) {
            schemaObject.setExclusiveMinimum(Boolean.valueOf(schema.exclusiveMinimum()));
            isEmpty = false;
        }
        if (schema.maxLength() > 0 && schema.maxProperties() > 0) {
            schemaObject.setMaxProperties(Integer.valueOf(schema.maxProperties()));
            isEmpty = false;
        }
        if (schema.minProperties() > 0) {
            schemaObject.setMinProperties(Integer.valueOf(schema.minProperties()));
            isEmpty = false;
        }
        ReaderUtils.getStringListFromStringArray(schema._enum()).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Schema)schemaObject).setEnum(arg_0));
        OperationParser.getExternalDocumentation(schema.externalDocs()).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Schema)schemaObject).setExternalDocs(arg_0));
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(schemaObject);
    }

    public static Optional<Set<Tag>> getTags(String[] tags) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashSet<Tag> tagsList = new LinkedHashSet<Tag>();
        boolean isEmpty = true;
        for (String tag : tags) {
            Tag tagObject = new Tag();
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                isEmpty = false;
            }
            tagObject.setDescription(tag);
            tagObject.setName(tag);
            tagsList.add(tagObject);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(tagsList);
    }

    public static Optional<List<Server>> getServers(io.swagger.oas.annotations.servers.Server[] servers) {
        if (servers == null) {
            return Optional.empty();
        }
        ArrayList serverObjects = new ArrayList();
        for (io.swagger.oas.annotations.servers.Server server : servers) {
            OperationParser.getServer(server).ifPresent(serverObjects::add);
        }
        if (serverObjects.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(serverObjects);
    }

    public static Optional<Server> getServer(io.swagger.oas.annotations.servers.Server server) {
        if (server == null) {
            return Optional.empty();
        }
        Server serverObject = new Server();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)server.url())) {
            serverObject.setUrl(server.url());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)server.description())) {
            serverObject.setDescription(server.description());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        io.swagger.oas.annotations.servers.ServerVariable[] serverVariables = server.variables();
        ServerVariables serverVariablesObject = new ServerVariables();
        for (io.swagger.oas.annotations.servers.ServerVariable serverVariable : serverVariables) {
            ServerVariable serverVariableObject = new ServerVariable();
            if (StringUtils.isNotBlank((CharSequence)serverVariable.description())) {
                serverVariableObject.setDescription(serverVariable.description());
            }
            serverVariablesObject.addServerVariable(serverVariable.name(), serverVariableObject);
        }
        serverObject.setVariables(serverVariablesObject);
        return Optional.of(serverObject);
    }

    public static Optional<ExternalDocumentation> getExternalDocumentation(io.swagger.oas.annotations.ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ExternalDocumentation external = new ExternalDocumentation();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(external);
    }

    public static Optional<io.swagger.oas.models.parameters.RequestBody> getRequestBody(RequestBody requestBody, Components components) {
        if (requestBody == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.parameters.RequestBody requestBodyObject = new io.swagger.oas.models.parameters.RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContents(requestBody.content(), components).ifPresent(arg_0 -> ((io.swagger.oas.models.parameters.RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public static Optional<ApiResponses> getApiResponses(ApiResponse[] responses, Produces classProduces, Produces methodProduces, Components components) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (ApiResponse response : responses) {
            io.swagger.oas.models.responses.ApiResponse apiResponseObject = new io.swagger.oas.models.responses.ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            OperationParser.getContent(response.content(), classProduces, methodProduces, components).ifPresent(arg_0 -> ((io.swagger.oas.models.responses.ApiResponse)apiResponseObject).content(arg_0));
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null) continue;
            Map<String, io.swagger.oas.models.links.Link> links = OperationParser.getLinks(response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            io.swagger.oas.models.responses.ApiResponse apiResponseObject = new io.swagger.oas.models.responses.ApiResponse();
            apiResponseObject.setDescription(DEFAULT_DESCRIPTION);
            apiResponsesObject._default(apiResponseObject);
        }
        return Optional.of(apiResponsesObject);
    }

    public static Optional<io.swagger.oas.models.media.Content> getContents(Content[] contents, Components components) {
        if (contents == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.media.Content contentObject = new io.swagger.oas.models.media.Content();
        MediaType mediaType = new MediaType();
        for (Content content : contents) {
            ExampleObject[] examples;
            for (ExampleObject example : examples = content.examples()) {
                OperationParser.getMediaType(mediaType, example).ifPresent(mediaTypeObject -> contentObject.addMediaType(content.mediaType(), mediaType));
            }
        }
        if (contentObject.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(contentObject);
    }

    public static Optional<io.swagger.oas.models.media.Content> getContent(Content annotationContent, Produces classProduces, Produces methodProduces, Components components) {
        ExampleObject[] examples;
        if (annotationContent == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.media.Content content = new io.swagger.oas.models.media.Content();
        MediaType mediaType = new MediaType();
        Class schemaImplementation = annotationContent.schema().implementation();
        if (schemaImplementation != Void.class) {
            String[] schemaObject = new io.swagger.oas.models.media.Schema();
            if (schemaImplementation.getName().startsWith("java.lang")) {
                schemaObject.setType(schemaImplementation.getSimpleName().toLowerCase());
            } else {
                Map schemaMap = ModelConverters.getInstance().readAll((Type)schemaImplementation);
                schemaMap.forEach((key, schema) -> components.addSchemas(key, schema));
                schemaObject.set$ref(COMPONENTS_REF + schemaImplementation.getSimpleName());
            }
            mediaType.setSchema((io.swagger.oas.models.media.Schema)schemaObject);
        } else {
            OperationParser.getSchemaFromAnnotation(annotationContent.schema()).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
        }
        if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
            content.addMediaType(annotationContent.mediaType(), mediaType);
        } else if (mediaType.getSchema() != null) {
            if (methodProduces != null) {
                for (String value : methodProduces.value()) {
                    content.addMediaType(value, mediaType);
                }
            } else if (classProduces != null) {
                for (String value : classProduces.value()) {
                    content.addMediaType(value, mediaType);
                }
            } else {
                content.addMediaType(MEDIA_TYPE, mediaType);
            }
        }
        for (ExampleObject example : examples = annotationContent.examples()) {
            OperationParser.getMediaType(mediaType, example).ifPresent(mediaTypeObject -> content.addMediaType(annotationContent.mediaType(), mediaTypeObject));
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<MediaType> getMediaType(MediaType mediaType, ExampleObject example) {
        if (example == null) {
            return Optional.empty();
        }
        if (StringUtils.isNotBlank((CharSequence)example.name())) {
            Example exampleObject = new Example();
            if (StringUtils.isNotBlank((CharSequence)example.name())) {
                exampleObject.setDescription(example.name());
            }
            if (StringUtils.isNotBlank((CharSequence)example.summary())) {
                exampleObject.setSummary(example.summary());
            }
            if (StringUtils.isNotBlank((CharSequence)example.externalValue())) {
                exampleObject.setExternalValue(example.externalValue());
            }
            if (StringUtils.isNotBlank((CharSequence)example.value())) {
                try {
                    exampleObject.setValue((Object)Json.mapper().readTree(example.value()));
                }
                catch (IOException e) {
                    exampleObject.setValue((Object)example.value());
                }
            }
            mediaType.addExamples(example.name(), exampleObject);
            return Optional.of(mediaType);
        }
        return Optional.empty();
    }

    public static Optional<io.swagger.oas.models.info.Info> getInfo(Info info) {
        if (info == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.info.Info infoObject = new io.swagger.oas.models.info.Info();
        if (StringUtils.isNotBlank((CharSequence)info.description())) {
            infoObject.setDescription(info.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.termsOfService())) {
            infoObject.setTermsOfService(info.termsOfService());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.title())) {
            infoObject.setTitle(info.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.version())) {
            infoObject.setVersion(info.version());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContact(info.contact()).ifPresent(arg_0 -> ((io.swagger.oas.models.info.Info)infoObject).setContact(arg_0));
        OperationParser.getLicense(info.license()).ifPresent(arg_0 -> ((io.swagger.oas.models.info.Info)infoObject).setLicense(arg_0));
        return Optional.of(infoObject);
    }

    public static Optional<io.swagger.oas.models.info.Contact> getContact(Contact contact) {
        if (contact == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.info.Contact contactObject = new io.swagger.oas.models.info.Contact();
        if (StringUtils.isNotBlank((CharSequence)contact.email())) {
            contactObject.setEmail(contact.email());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.name())) {
            contactObject.setName(contact.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.url())) {
            contactObject.setUrl(contact.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(contactObject);
    }

    public static Optional<io.swagger.oas.models.info.License> getLicense(License license) {
        if (license == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.info.License licenseObject = new io.swagger.oas.models.info.License();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)license.name())) {
            licenseObject.setName(license.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)license.url())) {
            licenseObject.setUrl(license.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(licenseObject);
    }

    public static Map<String, io.swagger.oas.models.links.Link> getLinks(Link[] links) {
        HashMap<String, io.swagger.oas.models.links.Link> linkMap = new HashMap<String, io.swagger.oas.models.links.Link>();
        if (links == null) {
            return linkMap;
        }
        for (Link link : links) {
            OperationParser.getLink(link).ifPresent(linkResult -> linkMap.put(link.name(), (io.swagger.oas.models.links.Link)linkResult));
        }
        return linkMap;
    }

    public static Optional<io.swagger.oas.models.links.Link> getLink(Link link) {
        if (link == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.links.Link linkObject = new io.swagger.oas.models.links.Link();
        if (StringUtils.isNotBlank((CharSequence)link.description())) {
            linkObject.setDescription(link.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationId())) {
            linkObject.setOperationId(link.operationId());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
            linkObject.setOperationRef(link.operationRef());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        Map<String, String> linkParameters = OperationParser.getLinkParameters(link.parameters());
        if (linkParameters.size() > 0) {
            linkObject.setParameters(linkParameters);
        }
        return Optional.of(linkObject);
    }

    public static Map<String, String> getLinkParameters(LinkParameters linkParameters) {
        HashMap<String, String> linkParametersMap = new HashMap<String, String>();
        if (linkParameters == null) {
            return linkParametersMap;
        }
        if (StringUtils.isNotBlank((CharSequence)linkParameters.name())) {
            linkParametersMap.put(linkParameters.name(), linkParameters.expression());
        }
        return linkParametersMap;
    }
}

