/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs2.OperationParser;
import io.swagger.jaxrs2.SecurityParser;
import io.swagger.jaxrs2.ext.OpenAPIExtension;
import io.swagger.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.jaxrs2.util.ReaderUtils;
import io.swagger.oas.annotations.ExternalDocumentation;
import io.swagger.oas.annotations.Operation;
import io.swagger.oas.annotations.callbacks.Callback;
import io.swagger.oas.annotations.info.Info;
import io.swagger.oas.annotations.security.SecurityRequirement;
import io.swagger.oas.annotations.security.SecurityScheme;
import io.swagger.oas.integration.ContextUtils;
import io.swagger.oas.integration.SwaggerConfiguration;
import io.swagger.oas.integration.api.OpenAPIConfiguration;
import io.swagger.oas.integration.api.OpenApiReader;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.tags.Tag;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader
implements OpenApiReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    public static final String DEFAULT_MEDIA_TYPE_VALUE = "*/*";
    protected OpenAPIConfiguration config;
    private OpenAPI openAPI = new OpenAPI();
    private Components components;
    private Paths paths = new Paths();
    private Set<Tag> openApiTags = new LinkedHashSet<Tag>();
    Consumes classConsumes;
    Produces classProduces;
    Produces methodProduces;
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String PATCH_METHOD = "patch";
    private static final String TRACE_METHOD = "trace";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";

    public Reader() {
        this.components = new Components();
    }

    public Reader(OpenAPI openAPI) {
        this();
        this.setConfiguration((OpenAPIConfiguration)new SwaggerConfiguration().openAPI(openAPI));
    }

    public Reader(OpenAPIConfiguration openApiConfiguration) {
        this();
        this.setConfiguration(openApiConfiguration);
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public OpenAPI read(Class<?> cls) {
        return this.read(cls, "");
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                if (class1.equals(class2)) {
                    return 0;
                }
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
                return class1.getName().compareTo(class2.getName());
            }
        });
        sortedClasses.addAll(classes);
        for (Class clazz : sortedClasses) {
            this.read(clazz, "");
        }
        return this.openAPI;
    }

    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        if (openApiConfiguration != null) {
            this.config = ContextUtils.deepCopy((OpenAPIConfiguration)openApiConfiguration);
            if (openApiConfiguration.getOpenAPI() != null) {
                this.openAPI = this.config.getOpenAPI();
            }
        }
    }

    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        return this.read(classes);
    }

    public OpenAPI read(Class<?> cls, String parentPath) {
        Method[] methods;
        SecurityScheme apiSecurityScheme = (SecurityScheme)ReflectionUtils.getAnnotation(cls, SecurityScheme.class);
        ExternalDocumentation apiExternalDocs = (ExternalDocumentation)ReflectionUtils.getAnnotation(cls, ExternalDocumentation.class);
        Info apiInfo = (Info)ReflectionUtils.getAnnotation(cls, Info.class);
        this.classConsumes = (Consumes)ReflectionUtils.getAnnotation(cls, Consumes.class);
        this.classProduces = (Produces)ReflectionUtils.getAnnotation(cls, Produces.class);
        Optional<io.swagger.oas.models.security.SecurityScheme> securityScheme = SecurityParser.getSecurityScheme(apiSecurityScheme);
        if (securityScheme.isPresent()) {
            HashMap<String, io.swagger.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.oas.models.security.SecurityScheme>();
            if (StringUtils.isNotBlank((CharSequence)securityScheme.get().getName())) {
                securitySchemeMap.put(securityScheme.get().getName(), securityScheme.get());
                if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() != 0) {
                    this.components.getSecuritySchemes().putAll(securitySchemeMap);
                } else {
                    this.components.setSecuritySchemes(securitySchemeMap);
                }
            }
        }
        Path apiPath = (Path)ReflectionUtils.getAnnotation(cls, Path.class);
        JavaType classType = TypeFactory.defaultInstance().constructType(cls);
        BeanDescription bd = Json.mapper().getSerializationConfig().introspect(classType);
        ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.openAPI));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.openAPI));
        for (Method method : methods = cls.getMethods()) {
            JavaType type;
            io.swagger.oas.models.Operation operation;
            RequestBody requestBody = new RequestBody();
            AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), (Class[])method.getParameterTypes());
            this.methodProduces = (Produces)ReflectionUtils.getAnnotation((Method)method, Produces.class);
            if (ReflectionUtils.isOverriddenMethod((Method)method, cls)) continue;
            Path methodPath = (Path)ReflectionUtils.getAnnotation((Method)method, Path.class);
            Consumes methodConsumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class);
            String operationPath = ReaderUtils.getPath(apiPath, methodPath, parentPath);
            LinkedHashMap regexMap = new LinkedHashMap();
            if ((operationPath = PathUtils.parsePath((String)operationPath, regexMap)) == null || ReaderUtils.isIgnored(operationPath, this.config) || (operation = this.parseMethod(method)) == null) continue;
            PathItem pathItemObject = this.openAPI.getPaths() != null && this.openAPI.getPaths().get((Object)operationPath) != null ? (PathItem)this.openAPI.getPaths().get((Object)operationPath) : new PathItem();
            String httpMethod = ReaderUtils.extractOperationMethod(operation, method, OpenAPIExtensions.chain());
            if (StringUtils.isNotBlank((CharSequence)httpMethod)) {
                this.setPathItemOperation(pathItemObject, httpMethod, operation);
            }
            ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
            Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations((Method)method);
            if (annotatedMethod == null) {
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                    operationParameters.addAll(this.getParameters((Type)type, Arrays.asList(paramAnnotations[i])));
                }
            } else {
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                    List<Parameter> parameters = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]));
                    for (Parameter parameter : parameters) {
                        Schema parameterSchema = parameter.getSchema();
                        if (StringUtils.isNotBlank((CharSequence)parameter.getIn())) {
                            operationParameters.add(parameter);
                            continue;
                        }
                        boolean isRequestBodyEmpty = true;
                        if (StringUtils.isNotBlank((CharSequence)parameter.get$ref())) {
                            requestBody.set$ref(parameter.get$ref());
                            isRequestBodyEmpty = false;
                        }
                        if (StringUtils.isNotBlank((CharSequence)parameter.getDescription())) {
                            requestBody.setDescription(parameter.getDescription());
                            isRequestBodyEmpty = false;
                        }
                        if (Boolean.TRUE.equals(parameter.getRequired())) {
                            requestBody.setRequired(parameter.getRequired());
                            isRequestBodyEmpty = false;
                        }
                        if (parameter.getSchema() != null) {
                            Content content = new Content();
                            if (methodConsumes != null) {
                                for (String value : methodConsumes.value()) {
                                    this.setMediaTypeToContent(parameter.getSchema(), content, value);
                                }
                            } else if (this.classConsumes != null) {
                                for (String value : this.classConsumes.value()) {
                                    this.setMediaTypeToContent(parameter.getSchema(), content, value);
                                }
                            } else {
                                this.setMediaTypeToContent(parameter.getSchema(), content, DEFAULT_MEDIA_TYPE_VALUE);
                            }
                            requestBody.setContent(content);
                            isRequestBodyEmpty = false;
                        }
                        if (isRequestBodyEmpty) continue;
                        if (parameterSchema != null) {
                            Map schemaMap = ModelConverters.getInstance().readAll((Type)type);
                            schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
                        }
                        operation.setRequestBody(requestBody);
                    }
                }
            }
            if (operationParameters.size() > 0) {
                operation.setParameters(operationParameters);
            }
            this.paths.addPathItem(operationPath, pathItemObject);
            if (this.openAPI.getPaths() != null) {
                this.paths.putAll((Map)this.openAPI.getPaths());
            }
            this.openAPI.setPaths(this.paths);
        }
        if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() > 0 || this.components.getSchemas() != null && this.components.getSchemas().size() > 0) {
            this.openAPI.setComponents(this.components);
        }
        if (!this.openApiTags.isEmpty()) {
            LinkedHashSet<Tag> tagsSet = new LinkedHashSet<Tag>();
            tagsSet.addAll(this.openApiTags);
            if (this.openAPI.getTags() != null) {
                tagsSet.addAll(this.openAPI.getTags());
            }
            this.openAPI.setTags(new ArrayList(tagsSet));
        }
        OperationParser.getExternalDocumentation(apiExternalDocs).ifPresent(externalDocumentation -> this.openAPI.setExternalDocs(externalDocumentation));
        OperationParser.getInfo(apiInfo).ifPresent(info -> this.openAPI.setInfo(info));
        return this.openAPI;
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }

    public io.swagger.oas.models.Operation parseMethod(Method method) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method);
    }

    private io.swagger.oas.models.Operation parseMethod(Class<?> cls, Method method) {
        Map schemaMap;
        io.swagger.oas.models.Operation operation = new io.swagger.oas.models.Operation();
        Operation apiOperation = (Operation)ReflectionUtils.getAnnotation((Method)method, Operation.class);
        Callback apiCallback = (Callback)ReflectionUtils.getAnnotation((Method)method, Callback.class);
        SecurityRequirement apiSecurity = (SecurityRequirement)ReflectionUtils.getAnnotation((Method)method, SecurityRequirement.class);
        if (apiOperation != null) {
            Map<String, io.swagger.oas.models.callbacks.Callback> callbacks = this.getCallbacks(apiCallback);
            if (callbacks.size() > 0) {
                operation.setCallbacks(callbacks);
            }
            SecurityParser.getSecurityRequirement(apiSecurity).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setSecurity(arg_0));
            this.setOperationObjectFromApiOperationAnnotation(operation, apiOperation);
            if (StringUtils.isBlank((CharSequence)operation.getOperationId())) {
                operation.setOperationId(method.getName());
            }
        } else {
            return null;
        }
        Type returnType = method.getGenericReturnType();
        if (!this.shouldIgnoreClass(returnType.getTypeName()) && (schemaMap = ModelConverters.getInstance().read(returnType)) != null && !schemaMap.values().isEmpty()) {
            Schema returnTypeSchema = (Schema)schemaMap.values().iterator().next();
            if (operation.getResponses() == null) {
                operation.responses(new ApiResponses()._default(new ApiResponse().content(new Content().addMediaType(DEFAULT_MEDIA_TYPE_VALUE, new MediaType().schema(new Schema().$ref(returnTypeSchema.getName()))))));
            }
            if (operation.getResponses().getDefault() != null && StringUtils.isBlank((CharSequence)operation.getResponses().getDefault().get$ref()) && operation.getResponses().getDefault().getContent() == null) {
                operation.getResponses().getDefault().content(new Content().addMediaType(DEFAULT_MEDIA_TYPE_VALUE, new MediaType().schema(new Schema().$ref(returnTypeSchema.getName()))));
            }
            schemaMap = ModelConverters.getInstance().readAll(returnType);
            schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
        }
        return operation;
    }

    private boolean shouldIgnoreClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return true;
        }
        boolean ignore = false;
        ignore = ignore || className.startsWith("javax.ws.rs.");
        ignore = ignore || className.equalsIgnoreCase("void");
        return ignore;
    }

    private Map<String, io.swagger.oas.models.callbacks.Callback> getCallbacks(Callback apiCallback) {
        HashMap<String, io.swagger.oas.models.callbacks.Callback> callbackMap = new HashMap<String, io.swagger.oas.models.callbacks.Callback>();
        if (apiCallback == null) {
            return callbackMap;
        }
        io.swagger.oas.models.callbacks.Callback callbackObject = new io.swagger.oas.models.callbacks.Callback();
        PathItem pathItemObject = new PathItem();
        for (Operation callbackOperation : apiCallback.operation()) {
            io.swagger.oas.models.Operation callbackNewOperation = new io.swagger.oas.models.Operation();
            this.setOperationObjectFromApiOperationAnnotation(callbackNewOperation, callbackOperation);
            this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
        }
        callbackObject.addPathItem(apiCallback.callbackUrlExpression(), pathItemObject);
        callbackMap.put(apiCallback.name(), callbackObject);
        return callbackMap;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, io.swagger.oas.models.Operation callbackNewOperation) {
        switch (method) {
            case "post": {
                pathItemObject.post(callbackNewOperation);
                break;
            }
            case "get": {
                pathItemObject.get(callbackNewOperation);
                break;
            }
            case "delete": {
                pathItemObject.delete(callbackNewOperation);
                break;
            }
            case "put": {
                pathItemObject.put(callbackNewOperation);
                break;
            }
            case "patch": {
                pathItemObject.patch(callbackNewOperation);
                break;
            }
            case "trace": {
                pathItemObject.trace(callbackNewOperation);
                break;
            }
            case "head": {
                pathItemObject.head(callbackNewOperation);
                break;
            }
            case "options": {
                pathItemObject.options(callbackNewOperation);
                break;
            }
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(io.swagger.oas.models.Operation operation, Operation apiOperation) {
        if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId()));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
        }
        ReaderUtils.getStringListFromStringArray(apiOperation.tags()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setTags(arg_0));
        OperationParser.getTags(apiOperation.tags()).ifPresent(tag -> this.openApiTags.addAll((Collection<Tag>)tag));
        OperationParser.getExternalDocumentation(apiOperation.externalDocs()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setExternalDocs(arg_0));
        OperationParser.getRequestBody(apiOperation.requestBody(), this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setRequestBody(arg_0));
        OperationParser.getApiResponses(apiOperation.responses(), this.classProduces, this.methodProduces, this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setResponses(arg_0));
        OperationParser.getServers(apiOperation.servers()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setServers(arg_0));
        OperationParser.getParametersList(apiOperation.parameters(), this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setParameters(arg_0));
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.openAPI == null) {
            return false;
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : this.openAPI.getPaths().values()) {
            String pathOperationId = this.extractOperationIdFromPathItem(path);
            if (!operationId.equalsIgnoreCase(pathOperationId)) continue;
            return true;
        }
        return false;
    }

    private List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        Parameter param;
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        if (!chain.hasNext()) {
            return Collections.emptyList();
        }
        LOGGER.debug("getParameters for {}", (Object)type);
        HashSet<Type> typesToSkip = new HashSet<Type>();
        OpenAPIExtension extension = chain.next();
        LOGGER.debug("trying extension {}", (Object)extension);
        List<Parameter> parameters = extension.extractParameters(annotations, type, typesToSkip, chain);
        if (!parameters.isEmpty()) {
            ArrayList<Parameter> processed = new ArrayList<Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                if (ParameterProcessor.applyAnnotations((OpenAPI)this.openAPI, (Parameter)parameter, (Type)type, annotations) == null) continue;
                processed.add(parameter);
                Map schemaMap = ModelConverters.getInstance().readAll(type);
                schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
            }
            return processed;
        }
        LOGGER.debug("no parameter found, looking at body params");
        ArrayList<Parameter> body = new ArrayList<Parameter>();
        if (!typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((OpenAPI)this.openAPI, null, (Type)type, annotations)) != null) {
            body.add(param);
        }
        return body;
    }

    private void mergeComponents(OpenAPI openAPI, boolean isComponentEmpty) {
        Components openAPIComponent = openAPI.getComponents();
        if (!isComponentEmpty) {
            if (openAPIComponent != null) {
                if (this.components.getCallbacks() != null) {
                    this.components.getCallbacks().putAll(openAPIComponent.getCallbacks());
                }
                if (this.components.getExamples() != null) {
                    this.components.getExamples().putAll(openAPIComponent.getExamples());
                }
                if (this.components.getExtensions() != null) {
                    this.components.getExtensions().putAll(openAPIComponent.getExtensions());
                }
                if (this.components.getHeaders() != null) {
                    this.components.getHeaders().putAll(openAPIComponent.getHeaders());
                }
                if (this.components.getLinks() != null) {
                    this.components.getLinks().putAll(openAPIComponent.getLinks());
                }
                if (this.components.getParameters() != null) {
                    this.components.getParameters().putAll(openAPIComponent.getParameters());
                }
                if (this.components.getRequestBodies() != null) {
                    this.components.getRequestBodies().putAll(openAPIComponent.getRequestBodies());
                }
                if (this.components.getResponses() != null) {
                    this.components.getResponses().putAll(openAPIComponent.getResponses());
                }
                if (this.components.getSchemas() != null) {
                    this.components.getSchemas().putAll(openAPIComponent.getSchemas());
                }
            }
            openAPI.setComponents(this.components);
        }
    }

    private String extractOperationIdFromPathItem(PathItem path) {
        if (path.getGet() != null) {
            return path.getGet().getOperationId();
        }
        if (path.getPost() != null) {
            return path.getPost().getOperationId();
        }
        if (path.getPut() != null) {
            return path.getPut().getOperationId();
        }
        if (path.getDelete() != null) {
            return path.getDelete().getOperationId();
        }
        if (path.getOptions() != null) {
            return path.getOptions().getOperationId();
        }
        if (path.getHead() != null) {
            return path.getHead().getOperationId();
        }
        if (path.getPatch() != null) {
            return path.getPatch().getOperationId();
        }
        return "";
    }
}

