/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import io.swagger.oas.annotations.security.Scopes;
import io.swagger.oas.annotations.security.SecurityRequirement;
import io.swagger.oas.models.security.OAuthFlow;
import io.swagger.oas.models.security.OAuthFlows;
import io.swagger.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SecurityParser {
    public static final String SCOPE_NAME = "name";
    public static final String SCOPE_DESCRIPTION = "description";

    public static Optional<List<io.swagger.oas.models.security.SecurityRequirement>> getSecurityRequirement(SecurityRequirement securityRequirement) {
        if (securityRequirement == null) {
            return Optional.empty();
        }
        ArrayList<io.swagger.oas.models.security.SecurityRequirement> securityRequirements = new ArrayList<io.swagger.oas.models.security.SecurityRequirement>();
        io.swagger.oas.models.security.SecurityRequirement securityRequirementObject = new io.swagger.oas.models.security.SecurityRequirement();
        if (securityRequirement.scopes().length > 0) {
            securityRequirementObject.addList(securityRequirement.name(), Arrays.asList(securityRequirement.scopes()));
        } else {
            securityRequirementObject.addList(securityRequirement.name());
        }
        securityRequirements.add(securityRequirementObject);
        return Optional.of(securityRequirements);
    }

    public static Optional<SecurityScheme> getSecurityScheme(io.swagger.oas.annotations.security.SecurityScheme securityScheme) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in())) {
            securitySchemeObject.setIn(SecurityParser.getIn(securityScheme.in()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type())) {
            securitySchemeObject.setType(SecurityParser.getType(securityScheme.type()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(securityScheme.openIdConnectUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.name())) {
            securitySchemeObject.setName(securityScheme.name());
        }
        SecurityParser.getOAuthFlows(securityScheme.flows()).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        return Optional.of(securitySchemeObject);
    }

    public static Optional<OAuthFlows> getOAuthFlows(io.swagger.oas.annotations.security.OAuthFlows oAuthFlows) {
        if (SecurityParser.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        OAuthFlows oAuthFlowsObject = new OAuthFlows();
        SecurityParser.getOAuthFlow(oAuthFlows.authorizationCode()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.clientCredentials()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.implicit()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.password()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    public static Optional<OAuthFlow> getOAuthFlow(io.swagger.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (SecurityParser.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(oAuthFlow.authorizationUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(oAuthFlow.refreshUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(oAuthFlow.tokenUrl());
        }
        SecurityParser.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    public static Optional<io.swagger.oas.models.security.Scopes> getScopes(Scopes scopes) {
        if (SecurityParser.isEmpty(scopes)) {
            return Optional.empty();
        }
        io.swagger.oas.models.security.Scopes scopesObject = new io.swagger.oas.models.security.Scopes();
        scopesObject.addString(SCOPE_NAME, scopes.name());
        scopesObject.addString(SCOPE_DESCRIPTION, scopes.description());
        return Optional.of(scopesObject);
    }

    private static SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static boolean isEmpty(io.swagger.oas.annotations.security.OAuthFlows oAuthFlows) {
        if (oAuthFlows == null) {
            return true;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.implicit())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.authorizationCode())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.clientCredentials())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlows.password());
    }

    private static boolean isEmpty(io.swagger.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (oAuthFlow == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlow.scopes());
    }

    private static boolean isEmpty(Scopes scopes) {
        if (scopes == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)scopes.description())) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)scopes.name());
    }
}

