/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration;

import io.swagger.jaxrs2.integration.api.JaxrsOpenApiScanner;
import io.swagger.oas.integration.SwaggerConfiguration;
import io.swagger.oas.integration.api.OpenAPIConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsAnnotationScanner<T extends JaxrsAnnotationScanner<T>>
implements JaxrsOpenApiScanner {
    protected OpenAPIConfiguration openApiConfiguration;
    protected Application application;
    protected static Logger LOGGER = LoggerFactory.getLogger(JaxrsAnnotationScanner.class);

    public JaxrsAnnotationScanner application(Application application) {
        this.application = application;
        return this;
    }

    @Override
    public void setApplication(Application application) {
        this.application = application;
    }

    public T openApiConfiguration(OpenAPIConfiguration openApiConfiguration) {
        this.openApiConfiguration = openApiConfiguration;
        return (T)this;
    }

    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        this.openApiConfiguration = openApiConfiguration;
    }

    public Set<Class<?>> classes() {
        if (this.openApiConfiguration == null) {
            this.openApiConfiguration = new SwaggerConfiguration();
        }
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        boolean allowAllPackages = false;
        if (this.openApiConfiguration.getResourcePackages() != null && !this.openApiConfiguration.getResourcePackages().isEmpty()) {
            for (String pkg : this.openApiConfiguration.getResourcePackages()) {
                if ("".equals(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        } else {
            allowAllPackages = true;
        }
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set classes = reflections.getTypesAnnotatedWith(Path.class);
        HashSet output = new HashSet();
        for (Class cls : classes) {
            if (allowAllPackages) {
                output.add(cls);
                continue;
            }
            for (String pkg : acceptablePackages) {
                if (!cls.getPackage().getName().startsWith(pkg)) continue;
                output.add(cls);
            }
        }
        LOGGER.trace("classes() - output size {}", (Object)output.size());
        return output;
    }

    @Override
    public Map<String, Object> resources() {
        return new HashMap<String, Object>();
    }
}

