/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration;

import io.swagger.jaxrs2.Reader;
import io.swagger.jaxrs2.integration.JaxrsApplicationAndAnnotationScanner;
import io.swagger.jaxrs2.integration.api.JaxrsOpenApiScanner;
import io.swagger.oas.integration.GenericOpenApiContext;
import io.swagger.oas.integration.api.OpenAPIConfiguration;
import io.swagger.oas.integration.api.OpenApiContext;
import io.swagger.oas.integration.api.OpenApiReader;
import io.swagger.oas.integration.api.OpenApiScanner;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsOpenApiContext<T extends JaxrsOpenApiContext>
extends GenericOpenApiContext<JaxrsOpenApiContext>
implements OpenApiContext {
    Logger LOGGER = LoggerFactory.getLogger(JaxrsOpenApiContext.class);
    private Application app;

    public T app(Application app) {
        this.app = app;
        return (T)((Object)this);
    }

    protected OpenApiReader buildReader(OpenAPIConfiguration openApiConfiguration) throws Exception {
        Reader reader;
        if (StringUtils.isNotBlank((CharSequence)openApiConfiguration.getReaderClass())) {
            Class<?> cls = ((Object)((Object)this)).getClass().getClassLoader().loadClass(openApiConfiguration.getReaderClass());
            reader = (OpenApiReader)cls.newInstance();
        } else {
            reader = new Reader();
        }
        reader.setConfiguration(openApiConfiguration);
        return reader;
    }

    protected OpenApiScanner buildScanner(OpenAPIConfiguration openApiConfiguration) throws Exception {
        JaxrsApplicationAndAnnotationScanner scanner;
        if (StringUtils.isNotBlank((CharSequence)openApiConfiguration.getScannerClass())) {
            Class<?> cls = ((Object)((Object)this)).getClass().getClassLoader().loadClass(openApiConfiguration.getScannerClass());
            scanner = (OpenApiScanner)cls.newInstance();
        } else {
            scanner = new JaxrsApplicationAndAnnotationScanner();
        }
        scanner.setConfiguration(openApiConfiguration);
        if (scanner instanceof JaxrsOpenApiScanner) {
            ((JaxrsOpenApiScanner)scanner).setApplication(this.app);
        }
        return scanner;
    }
}

