/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2.integration.resources;

import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.oas.integration.api.OpenAPIConfiguration;
import io.swagger.oas.integration.api.OpenApiContext;
import io.swagger.oas.models.OpenAPI;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOpenApiResource {
    private static Logger LOGGER = LoggerFactory.getLogger(BaseOpenApiResource.class);
    protected String configLocation;
    protected Set<String> resourcePackages;
    protected OpenAPIConfiguration openApiConfiguration;

    protected Response getOpenApi(HttpHeaders headers, ServletConfig config, Application app, UriInfo uriInfo, String type) throws Exception {
        String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig(config);
        OpenApiContext ctx = ((JaxrsOpenApiContextBuilder)((Object)new JaxrsOpenApiContextBuilder().servletConfig(config))).application(app).resourcePackages(this.resourcePackages).configLocation(this.configLocation).openApiConfiguration(this.openApiConfiguration).ctxId(ctxId).buildContext(true);
        OpenAPI oas = ctx.read();
        boolean pretty = false;
        if (ctx.getOpenApiConfiguration() != null && Boolean.TRUE.equals(ctx.getOpenApiConfiguration().isPrettyPrint())) {
            pretty = true;
        }
        if (oas != null && ctx.getOpenApiConfiguration() != null && ctx.getOpenApiConfiguration().getFilterClass() != null) {
            try {
                SwaggerSpecFilter filterImpl = (SwaggerSpecFilter)Class.forName(ctx.getOpenApiConfiguration().getFilterClass()).newInstance();
                SpecFilter f = new SpecFilter();
                oas = f.filter(oas, filterImpl, BaseOpenApiResource.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), BaseOpenApiResource.getCookies(headers), BaseOpenApiResource.getHeaders(headers));
            }
            catch (Exception e) {
                LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
        if (oas == null) {
            return Response.status((int)404).build();
        }
        if (StringUtils.isNotBlank((CharSequence)type) && type.trim().equalsIgnoreCase("yaml")) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)(pretty ? Yaml.pretty((Object)oas) : Yaml.mapper().writeValueAsString((Object)oas))).type("application/yaml").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)(pretty ? Json.pretty((Object)oas) : Json.mapper().writeValueAsString((Object)oas))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static Map<String, List<String>> getQueryParams(MultivaluedMap<String, String> params) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (params != null) {
            for (String key : params.keySet()) {
                List values = (List)params.get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    private static Map<String, String> getCookies(HttpHeaders headers) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.getCookies().keySet()) {
                Cookie cookie = (Cookie)headers.getCookies().get(key);
                output.put(key, cookie.getValue());
            }
        }
        return output;
    }

    private static Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (headers != null) {
            for (String key : headers.getRequestHeaders().keySet()) {
                List values = (List)headers.getRequestHeaders().get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public BaseOpenApiResource configLocation(String configLocation) {
        this.setConfigLocation(configLocation);
        return this;
    }

    public Set<String> getResourcePackages() {
        return this.resourcePackages;
    }

    public void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages = resourcePackages;
    }

    public BaseOpenApiResource resourcePackages(Set<String> resourcePackages) {
        this.setResourcePackages(resourcePackages);
        return this;
    }

    public OpenAPIConfiguration getOpenApiConfiguration() {
        return this.openApiConfiguration;
    }

    public void setOpenApiConfiguration(OpenAPIConfiguration openApiConfiguration) {
        this.openApiConfiguration = openApiConfiguration;
    }

    public BaseOpenApiResource openApiConfiguration(OpenAPIConfiguration openApiConfiguration) {
        this.setOpenApiConfiguration(openApiConfiguration);
        return this;
    }
}

