/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.ClientHttpEndpointBase;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.clientconnection.ConnectResult;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.spi.metrics.ClientMetrics;
import java.util.ArrayDeque;
import java.util.Deque;

class WebSocketEndpoint
extends ClientHttpEndpointBase {
    private final int maxPoolSize;
    private final HttpChannelConnector connector;
    private final Deque<Waiter> waiters;
    private int inflightConnections;

    WebSocketEndpoint(ClientMetrics metrics, int port, String host, Object metric, int maxPoolSize, HttpChannelConnector connector, Runnable dispose) {
        super(metrics, port, host, metric, dispose);
        this.maxPoolSize = maxPoolSize;
        this.connector = connector;
        this.waiters = new ArrayDeque<Waiter>();
    }

    private void tryConnect(ContextInternal ctx, final Handler<AsyncResult<HttpClientConnection>> handler) {
        class Listener
        implements ConnectionListener<HttpClientConnection>,
        Handler<AsyncResult<ConnectResult<HttpClientConnection>>> {
            private HttpClientConnection conn;

            Listener() {
            }

            @Override
            public void onConcurrencyChange(long concurrency) {
            }

            @Override
            public void onRecycle() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvict() {
                Waiter h;
                WebSocketEndpoint.this.connectionRemoved(this.conn);
                WebSocketEndpoint webSocketEndpoint = WebSocketEndpoint.this;
                synchronized (webSocketEndpoint) {
                    if (--WebSocketEndpoint.this.inflightConnections > WebSocketEndpoint.this.maxPoolSize || WebSocketEndpoint.this.waiters.isEmpty()) {
                        return;
                    }
                    h = (Waiter)WebSocketEndpoint.this.waiters.poll();
                }
                WebSocketEndpoint.this.tryConnect(h.context, h.handler);
            }

            @Override
            public void handle(AsyncResult<ConnectResult<HttpClientConnection>> ar) {
                if (ar.succeeded()) {
                    HttpClientConnection c;
                    ConnectResult<HttpClientConnection> res = ar.result();
                    this.conn = c = res.connection();
                    WebSocketEndpoint.this.connectionAdded(c);
                    handler.handle(Future.succeededFuture(c));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        }
        Listener listener = new Listener();
        this.connector.connect(listener, ctx, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestConnection2(ContextInternal ctx, Handler<AsyncResult<HttpClientConnection>> handler) {
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            if (this.inflightConnections >= this.maxPoolSize) {
                this.waiters.add(new Waiter(handler, ctx));
                return;
            }
            ++this.inflightConnections;
        }
        this.tryConnect(ctx, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            this.waiters.forEach(waiter -> waiter.context.runOnContext(v -> waiter.handler.handle(Future.failedFuture("Closed"))));
            this.waiters.clear();
        }
    }

    private static class Waiter {
        final Handler<AsyncResult<HttpClientConnection>> handler;
        final ContextInternal context;

        Waiter(Handler<AsyncResult<HttpClientConnection>> handler, ContextInternal context) {
            this.handler = handler;
            this.context = context;
        }
    }
}

