/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.Shareable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class JsonArray
implements Iterable<Object>,
ClusterSerializable,
Shareable {
    private List<Object> list;

    public JsonArray(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + json);
        }
    }

    public JsonArray() {
        this.list = new ArrayList<Object>();
    }

    public JsonArray(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    public JsonArray(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + buf);
        }
    }

    public static JsonArray of(Object ... values) {
        if (values.length == 0) {
            return new JsonArray();
        }
        JsonArray arr = new JsonArray(new ArrayList(values.length));
        for (int i = 0; i < values.length; ++i) {
            arr.add(values[i]);
        }
        return arr;
    }

    public String getString(int pos) {
        Object val = this.list.get(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Instant) {
            return DateTimeFormatter.ISO_INSTANT.format((Instant)val);
        }
        if (val instanceof byte[]) {
            return JsonUtil.BASE64_ENCODER.encodeToString((byte[])val);
        }
        if (val instanceof Buffer) {
            return JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)val).getBytes());
        }
        if (val instanceof Enum) {
            return ((Enum)val).name();
        }
        return val.toString();
    }

    public Number getNumber(int pos) {
        return (Number)this.list.get(pos);
    }

    public Integer getInteger(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public Long getLong(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Double getDouble(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Float getFloat(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return Float.valueOf(number.floatValue());
    }

    public Boolean getBoolean(int pos) {
        return (Boolean)this.list.get(pos);
    }

    public JsonObject getJsonObject(int pos) {
        Object val = this.list.get(pos);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        }
        return (JsonObject)val;
    }

    public JsonArray getJsonArray(int pos) {
        Object val = this.list.get(pos);
        if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return (JsonArray)val;
    }

    public byte[] getBinary(int pos) {
        Object val = this.list.get(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        if (val instanceof Buffer) {
            return ((Buffer)val).getBytes();
        }
        String encoded = (String)val;
        return JsonUtil.BASE64_DECODER.decode(encoded);
    }

    public Buffer getBuffer(int pos) {
        Object val = this.list.get(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Buffer) {
            return (Buffer)val;
        }
        if (val instanceof byte[]) {
            return Buffer.buffer((byte[])val);
        }
        String encoded = (String)val;
        return Buffer.buffer(JsonUtil.BASE64_DECODER.decode(encoded));
    }

    public Instant getInstant(int pos) {
        Object val = this.list.get(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Instant) {
            return (Instant)val;
        }
        String encoded = (String)val;
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(int pos) {
        return JsonUtil.wrapJsonValue(this.list.get(pos));
    }

    public boolean hasNull(int pos) {
        return this.list.get(pos) == null;
    }

    public JsonArray addNull() {
        this.list.add(null);
        return this;
    }

    public JsonArray add(Object value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(int pos, Object value) {
        this.list.add(pos, value);
        return this;
    }

    public JsonArray addAll(JsonArray array) {
        this.list.addAll(array.list);
        return this;
    }

    public JsonArray setNull(int pos) {
        this.list.set(pos, null);
        return this;
    }

    public JsonArray set(int pos, Object value) {
        this.list.set(pos, value);
        return this;
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public boolean remove(Object value) {
        Object wrappedValue = JsonUtil.wrapJsonValue(value);
        for (int i = 0; i < this.list.size(); ++i) {
            Object otherWrapperValue = this.getValue(i);
            if (wrappedValue == null) {
                if (otherWrapperValue != null) continue;
                this.list.remove(i);
                return true;
            }
            if (!wrappedValue.equals(otherWrapperValue)) continue;
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public Object remove(int pos) {
        return JsonUtil.wrapJsonValue(this.list.remove(pos));
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List getList() {
        return this.list;
    }

    public JsonArray clear() {
        this.list.clear();
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iter(this.list.iterator());
    }

    public String encode() {
        return Json.CODEC.toString(this, false);
    }

    public Buffer toBuffer() {
        return Json.CODEC.toBuffer(this, false);
    }

    public String encodePrettily() {
        return Json.CODEC.toString(this, true);
    }

    @Override
    public JsonArray copy() {
        return this.copy(JsonUtil.DEFAULT_CLONER);
    }

    public JsonArray copy(Function<Object, ?> cloner) {
        ArrayList<Object> copiedList = new ArrayList<Object>(this.list.size());
        for (Object val : this.list) {
            copiedList.add(JsonUtil.deepCopy(val, cloner));
        }
        return new JsonArray(copiedList);
    }

    public Stream<Object> stream() {
        return JsonUtil.asStream(this.iterator());
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray other = (JsonArray)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object otherValue;
            Object thisValue = this.getValue(i);
            if (thisValue == (otherValue = other.getValue(i))) continue;
            if (thisValue instanceof Number && otherValue instanceof Number && thisValue.getClass() != otherValue.getClass()) {
                Number n1 = (Number)thisValue;
                Number n2 = (Number)otherValue;
                if ((thisValue instanceof Float || thisValue instanceof Double || otherValue instanceof Float || otherValue instanceof Double) && n1.doubleValue() == n2.doubleValue() || (thisValue instanceof Integer || thisValue instanceof Long || otherValue instanceof Integer || otherValue instanceof Long) && n1.longValue() == n2.longValue()) continue;
            }
            if (thisValue instanceof CharSequence && otherValue instanceof CharSequence && thisValue.getClass() != otherValue.getClass()) {
                CharSequence s1 = (CharSequence)thisValue;
                CharSequence s2 = (CharSequence)otherValue;
                if (Objects.equals(s1.toString(), s2.toString())) continue;
            }
            if (Objects.equals(thisValue, otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        Buffer buf = this.toBuffer();
        buffer.appendInt(buf.length());
        buffer.appendBuffer(buf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start = pos + 4;
        Buffer buf = buffer.getBuffer(start, start + length);
        this.fromBuffer(buf);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.list = Json.CODEC.fromString(json, List.class);
    }

    private void fromBuffer(Buffer buf) {
        this.list = Json.CODEC.fromBuffer(buf, List.class);
    }

    private static class Iter
    implements Iterator<Object> {
        final Iterator<Object> listIter;

        Iter(Iterator<Object> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasNext();
        }

        @Override
        public Object next() {
            return JsonUtil.wrapJsonValue(this.listIter.next());
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }
    }
}

