/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.impl.RabbitMQClientImpl;

public class RabbitMQConfirmListenerImpl
implements ReadStream<RabbitMQConfirmation> {
    private final RabbitMQClientImpl client;
    private final InboundBuffer<RabbitMQConfirmation> pending;
    private final int maxQueueSize;
    private Handler<Throwable> exceptionHandler;

    public RabbitMQConfirmListenerImpl(RabbitMQClientImpl client, Context context, int maxQueueSize) {
        this.client = client;
        this.maxQueueSize = maxQueueSize;
        this.pending = new InboundBuffer(context, (long)maxQueueSize);
    }

    void handleAck(long deliveryTag, boolean multiple, boolean succeeded) {
        if (this.pending.size() >= this.maxQueueSize) {
            this.pending.read();
        }
        this.pending.write((Object)new RabbitMQConfirmation(this.client.getChannelInstance(), deliveryTag, multiple, succeeded));
    }

    public RabbitMQConfirmListenerImpl exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public RabbitMQConfirmListenerImpl handler(Handler<RabbitMQConfirmation> handler) {
        if (handler != null) {
            this.pending.handler(msg -> {
                try {
                    handler.handle(msg);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            });
        } else {
            this.pending.handler(null);
        }
        return this;
    }

    private void handleException(Throwable exception) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)exception);
        }
    }

    public RabbitMQConfirmListenerImpl pause() {
        this.pending.pause();
        return this;
    }

    public RabbitMQConfirmListenerImpl resume() {
        this.pending.resume();
        return this;
    }

    public RabbitMQConfirmListenerImpl fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    public RabbitMQConfirmListenerImpl endHandler(Handler<Void> hndlr) {
        return this;
    }
}

