/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisRole;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class RedisOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectionString": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConnectionString((String)member.getValue());
                    break;
                }
                case "connectionStrings": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addConnectionString((String)item);
                        }
                    });
                    break;
                }
                case "endpoint": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEndpoint((String)member.getValue());
                    break;
                }
                case "endpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEndpoints(list);
                    break;
                }
                case "hashSlotCacheTTL": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHashSlotCacheTTL(((Number)member.getValue()).longValue());
                    break;
                }
                case "masterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMasterName((String)member.getValue());
                    break;
                }
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolWaiting": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxPoolWaiting(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                    break;
                }
                case "netClientOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNetClientOptions(new NetClientOptions((JsonObject)member.getValue()));
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "poolCleanerInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolCleanerInterval(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPoolName((String)member.getValue());
                    break;
                }
                case "poolRecycleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPoolRecycleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "protocolNegotiation": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setProtocolNegotiation((Boolean)member.getValue());
                    break;
                }
                case "role": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRole(RedisRole.valueOf((String)member.getValue()));
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTracingPolicy(TracingPolicy.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(RedisClientType.valueOf((String)member.getValue()));
                    break;
                }
                case "useReplicas": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseReplicas(RedisReplicas.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(RedisOptions obj, JsonObject json) {
        RedisOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisOptions obj, Map<String, Object> json) {
        if (obj.getEndpoint() != null) {
            json.put("endpoint", obj.getEndpoint());
        }
        if (obj.getEndpoints() != null) {
            JsonArray array = new JsonArray();
            obj.getEndpoints().forEach(item -> array.add(item));
            json.put("endpoints", array);
        }
        json.put("hashSlotCacheTTL", obj.getHashSlotCacheTTL());
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        json.put("maxPoolSize", obj.getMaxPoolSize());
        json.put("maxPoolWaiting", obj.getMaxPoolWaiting());
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
        if (obj.getNetClientOptions() != null) {
            json.put("netClientOptions", obj.getNetClientOptions().toJson());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        json.put("poolCleanerInterval", obj.getPoolCleanerInterval());
        if (obj.getPoolName() != null) {
            json.put("poolName", obj.getPoolName());
        }
        json.put("poolRecycleTimeout", obj.getPoolRecycleTimeout());
        json.put("protocolNegotiation", obj.isProtocolNegotiation());
        if (obj.getRole() != null) {
            json.put("role", obj.getRole().name());
        }
        if (obj.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj.getTracingPolicy().name());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
        if (obj.getUseReplicas() != null) {
            json.put("useReplicas", obj.getUseReplicas().name());
        }
    }
}

