/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.io.output;

public final class MathUtils {
    static final int[] bitMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    public static int int2(int a, int b) {
        return (1 - ((a & 0x80) >> 6)) * ((a & 0xFF & 0x7F) << 8 | b & 0xFF);
    }

    public static int int3(int a, int b, int c) {
        return (1 - ((a & 0x80) >> 6)) * ((a & 0xFF & 0x7F) << 16 | (b & 0xFF) << 8 | c & 0xFF);
    }

    public static int int4(int a, int b, int c, int d) {
        return (1 - ((a & 0x80) >> 6)) * ((a & 0xFF & 0x7F) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF);
    }

    public static int uint2(int a, int b) {
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    public static int uint3(int a, int b, int c) {
        return (a & 0xFF) << 16 | (b & 0xFF) << 8 | c & 0xFF;
    }

    public static double IBM2FLoat(int a, int b, int c, int d) {
        boolean positive = true;
        int power = 0;
        int abspower = 0;
        int mant = 0;
        double value = 0.0;
        double exp = 0.0;
        positive = (a & 0x80) == 0;
        mant = MathUtils.uint3(b, c, d);
        power = (a & 0x7F) - 64;
        exp = 16.0;
        value = 1.0;
        for (abspower = power > 0 ? power : -power; abspower != 0; abspower >>= 1) {
            if ((abspower & 1) != 0) {
                value *= exp;
            }
            exp *= exp;
        }
        if (power < 0) {
            value = 1.0 / value;
        }
        value = value * (double)mant / 1.6777216E7;
        if (!positive) {
            value = -value;
        }
        return value;
    }

    public static byte[] Float2IBM(double fVal) {
        byte[] ibm = new byte[4];
        int sign = 0;
        int exp = 0;
        double mant = 0.0;
        int imant = 0;
        if (fVal == 0.0) {
            return ibm;
        }
        if (fVal < 0.0) {
            sign = 128;
            fVal = -fVal;
        } else {
            sign = 0;
        }
        mant = MathUtils.frexpMant(fVal);
        exp = MathUtils.frexpExp(fVal);
        if (mant >= 1.0) {
            mant = 0.5;
            ++exp;
        }
        while ((exp & 3) != 0) {
            mant *= 0.5;
            ++exp;
        }
        imant = (int)Math.floor(mant * 256.0 * 256.0 * 256.0 + 0.5);
        if (imant >= 0x1000000) {
            imant = (int)Math.floor(mant * 16.0 * 256.0 * 256.0 + 0.5);
            exp -= 4;
        }
        if ((exp = exp / 4 + 64) < 0) {
            System.err.println("underflow in flt2ibm");
            return null;
        }
        if (exp > 127) {
            System.err.println("overflow in flt2ibm");
            return null;
        }
        ibm[0] = (byte)(sign | exp);
        ibm[3] = (byte)(imant & 0xFF);
        ibm[2] = (byte)(imant >> 8 & 0xFF);
        ibm[1] = (byte)(imant >> 16 & 0xFF);
        return ibm;
    }

    public static byte[] bitVector2ByteVector(int bitVector, int length) {
        if (length <= 0 || length > 32) {
            return null;
        }
        byte octetsNumber = (byte)Math.ceil((double)length / 8.0);
        byte lastOctetNumBits = (byte)(length % 8 != 0 ? length % 8 : 8);
        byte[] retVal = new byte[(byte)Math.ceil((double)length / 8.0)];
        for (byte i = octetsNumber; i > 0; i = (byte)(i - 1)) {
            retVal[octetsNumber - i] = i == octetsNumber ? (byte)(bitVector >> (i - 1) * 8 & bitMask[lastOctetNumBits]) : (byte)(bitVector >> (i - 1) * 8 & bitMask[8]);
        }
        return retVal;
    }

    public static double log2(double val) {
        return Math.log(val) / Math.log(2.0);
    }

    public static double exp2(double val) {
        return Math.exp(val * Math.log(2.0));
    }

    public static byte[] signedInt2Bytes(int val, int numBytes) {
        boolean negative = false;
        if (val < 0) {
            negative = true;
            val = -val;
        }
        byte[] retVal = new byte[numBytes];
        switch (numBytes) {
            case 4: {
                retVal[0] = (byte)(val >> 24 & 0xFF);
                retVal[1] = (byte)(val >> 16 & 0xFF);
                retVal[2] = (byte)(val >> 8 & 0xFF);
                retVal[3] = (byte)(val & 0xFF);
                break;
            }
            case 3: {
                retVal[0] = (byte)(val >> 16 & 0xFF);
                retVal[1] = (byte)(val >> 8 & 0xFF);
                retVal[2] = (byte)(val & 0xFF);
                break;
            }
            case 2: {
                retVal[0] = (byte)(val >> 8 & 0xFF);
                retVal[1] = (byte)(val & 0xFF);
                break;
            }
            case 1: {
                retVal[0] = (byte)(val & 0xFF);
                break;
            }
            default: {
                return null;
            }
        }
        retVal[0] = (byte)(retVal[0] | (negative ? 128 : 0));
        return retVal;
    }

    public static double frexpMant(double val) {
        int intBits = Float.floatToIntBits((float)val);
        double mantissa = (double)(intBits &= (int)Math.pow(2.0, 23.0) - 1) * Math.pow(2.0, -23.0) + 1.0;
        return mantissa /= 2.0;
    }

    public static byte frexpExp(double val) {
        int intBits = Float.floatToIntBits((float)val);
        intBits >>>= 23;
        intBits &= 0xFF;
        intBits &= 0xFF;
        intBits -= 127;
        return (byte)(++intBits);
    }
}

