/*
 * Decompiled with CFR 0.152.
 */
package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.File;
import java.io.IOException;

public class FileUtilTest
extends Test {
    private void _checkCopyDir() throws IOException {
        this._enterSubTest("copyDir");
        String sTestSourceDir = FileUtil.createTempDir();
        String sTestDestinationDir = FileUtil.createTempDir();
        String sDirA = "a";
        String sDirB = FileUtil.concatPath(sDirA, "b");
        String sDirC = FileUtil.concatPath(sDirB, "c");
        String sFileF = FileUtil.concatPath(sDirB, "f");
        FileUtil.md(FileUtil.concatPath(sTestSourceDir, sDirA));
        FileUtil.md(FileUtil.concatPath(sTestSourceDir, sDirB));
        FileUtil.md(FileUtil.concatPath(sTestSourceDir, sDirC));
        FileUtil.writeFile(FileUtil.concatPath(sTestSourceDir, sFileF), "Test file\n");
        FileUtil.copyDir(sTestSourceDir, sTestDestinationDir);
        String sTestDirB = FileUtil.concatPath(sTestDestinationDir, FileUtil.concatPath(FileUtil.getBaseName(sTestSourceDir), sDirB));
        boolean bug = !FileUtil.existsDir(sTestDirB);
        this.bugIf(bug, "Directory '" + sTestDirB + "' should exist but it does not!");
        String sTestDirC = FileUtil.concatPath(sTestDirB, "c");
        bug |= !FileUtil.existsDir(sTestDirC);
        this.assert(FileUtil.existsDir(sTestDirC), "Directory '" + sTestDirC + "' should exist but it does not!");
        String sTestFileF = FileUtil.concatPath(sTestDirB, "f");
        boolean bl = !FileUtil.existsDir(sTestFileF);
        this.assert(FileUtil.existsFile(sTestFileF), "File '" + sTestFileF + "' should exist but it does not!");
        if (!(bug |= bl)) {
            FileUtil.deleteRecursively(sTestDestinationDir);
        }
        FileUtil.deleteRecursively(sTestSourceDir);
        this._exitSubTest();
    }

    private void _checkGetFiles() throws IOException {
        String sTestDir = FileUtil.createTempDir();
        this.assert(FileUtil.getFiles(sTestDir, "").size() == 0);
        FileUtil.writeFile(FileUtil.concatPath(sTestDir, ".emacs"), ";; test file\n");
        FileUtil.writeFile(FileUtil.concatPath(sTestDir, "ccl.jar"), "test");
        this.assert(FileUtil.getFiles(sTestDir, ".jar").size() == 1);
        this.assert(FileUtil.getFiles(sTestDir, ".zip" + File.pathSeparator + ".jar").size() == 1);
        this.assert(FileUtil.getFiles(sTestDir, ".jar" + File.pathSeparator + ".emacs").size() == 2);
        int result = FileUtil.getFiles(sTestDir, "").size();
        this.assert(result == 2, "There should be 2 files found in the test directory but we got " + result + ".");
        FileUtil.deleteRecursively(sTestDir);
        this.bugIf(FileUtil.exists(sTestDir));
    }

    public FileUtilTest() {
    }

    public FileUtilTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this._checkCopyDir();
        String sLocalPath = FileUtil.getClassPath(this);
        String sContent = "bla bla Schwachsinn!!!\n";
        String sFileName = FileUtil.concatPath(sLocalPath, "test.txt");
        String sFileNameBak = sFileName + ".bak";
        FileUtil.delete(sFileName);
        this.bugIf(FileUtil.exists(sFileName));
        try {
            FileUtil.writeFile(sFileName, sContent);
            this.bugIf(false);
        }
        catch (Exception e) {
            this.bugIf(true);
        }
        this.bugIf(!FileUtil.exists(sFileName));
        FileUtil.move(sFileName, sFileNameBak);
        this.bugIf(FileUtil.exists(sFileName));
        this.bugIf(!FileUtil.exists(sFileNameBak));
        FileUtil.delete(sFileNameBak);
        this.bugIf(FileUtil.exists(sFileNameBak));
        try {
            FileUtil.writeFile(sFileName, sContent);
            FileUtil.writeFile(sFileNameBak, sContent);
            this.bugIf(false);
        }
        catch (Exception e) {
            this.bugIf(true);
        }
        this.bugIf(!FileUtil.exists(sFileName));
        this.bugIf(!FileUtil.exists(sFileNameBak));
        FileUtil.move(sFileName, sFileNameBak);
        this.bugIf(FileUtil.exists(sFileName));
        this.bugIf(!FileUtil.exists(sFileNameBak));
        FileUtil.delete(sFileNameBak);
        this.bugIf(FileUtil.exists(sFileNameBak));
        try {
            FileUtil.writeFile(sFileNameBak, sContent);
            this.bugIf(false);
        }
        catch (Exception e) {
            this.bugIf(true);
        }
        this.bugIf(FileUtil.exists(sFileName));
        this.bugIf(!FileUtil.exists(sFileNameBak));
        boolean bError = FileUtil.move(sFileNameBak, sFileName);
        this.bugIf(bError, "Could not move file " + sFileNameBak + " to " + sFileName);
        this.bugIf(FileUtil.exists(sFileNameBak));
        this.bugIf(FileUtil.exists("_Asdf_"));
        this.bugIf(FileUtil.exists("h:\\eigen\\src\\java\\lib\\ccl\\util\\test\\_Asdf_"));
        this.bugIf(!FileUtil.exists(System.getProperty("user.dir")));
        this.bugIf(FileUtil.exists("h:/eigen/src/java/lib/ccl/util/test/_Asdf_"));
        this.bugIf(FileUtil.existsFile("_Asdf_"));
        this.bugIf(FileUtil.existsDir("_Asdf_"));
        this.bugIf(FileUtil.existsFile(sLocalPath));
        this.bugIf(Util.endsWith("", File.separatorChar));
        String sConcatPathResult = FileUtil.concatPath("", "gnudoit");
        this.bugIf(!sConcatPathResult.equals("gnudoit"), "sConcatPathResult: " + sConcatPathResult);
        String sPackagePath = null;
        String sHomePath = System.getProperty("user.home");
        this.bugIf(!FileUtil.existsDir(sHomePath));
        this.bugIf(FileUtil.existsFile(sHomePath));
        try {
            sPackagePath = FileUtil.getPackagePath(".", sHomePath);
            this.bugIf(!sPackagePath.equals(sHomePath), "sPackagePath: " + sPackagePath);
        }
        catch (Exception pException) {
            this.bugIf(true, "pException: " + pException);
        }
        String sTempDir = FileUtil.getTempDir();
        sTempDir = FileUtil.concatPath(sTempDir, "fileutiltest");
        FileUtil.md(sTempDir);
        this.assert(FileUtil.existsDir(sTempDir));
        String sTempFile = FileUtil.concatPath(sTempDir, "file");
        FileUtil.writeFile(sTempFile, "dummytext");
        this.assert(FileUtil.existsFile(sTempFile));
        this.bugIf(FileUtil.deleteRecursively(sTempDir));
        this.bugIf(FileUtil.exists(sTempDir));
        String sIniContent = FileUtil.getResourceAsString(this, "clearsight.ini");
        this.assert(sIniContent.indexOf("\nAuthor=Chr. Clemens Lee\n") != -1, "Resource string: " + sIniContent);
        this._checkGetFiles();
    }

    public static void main(String[] args) {
        FileUtilTest pTest = new FileUtilTest();
        pTest.setVerbose(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }
}

