/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import org.jboss.mx.util.QueryExpSupport;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    public String getAttributeName() {
        return this.attr;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        Object object = this.getAttribute(name);
        if (object != null && object instanceof String) {
            return new StringValueExp((String)object);
        }
        if (object != null && object instanceof Boolean) {
            return new BooleanValueExp((Boolean)object);
        }
        if (object != null && object instanceof Number) {
            return new NumericValueExp((Number)object);
        }
        throw new BadAttributeValueExpException(object);
    }

    public void setMBeanServer(MBeanServer server) {
        QueryExpSupport.server.set(server);
    }

    public String toString() {
        return this.attr;
    }

    protected Object getAttribute(ObjectName name) {
        try {
            return QueryEval.getMBeanServer().getAttribute(name, this.attr);
        }
        catch (Exception e) {
            return null;
        }
    }
}

