/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    private CompositeType rowType;
    private List indexNames;
    private transient int cachedHashCode = 0;
    private transient String cachedToString = null;
    private static final long serialVersionUID = 6554071860220659261L;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super((class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TabularType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName(), typeName, description);
        if (rowType == null) {
            throw new IllegalArgumentException("null rowType");
        }
        if (indexNames == null || indexNames.length == 0) {
            throw new IllegalArgumentException("null or empty indexNames");
        }
        this.rowType = rowType;
        this.indexNames = new ArrayList();
        for (int i = 0; i < indexNames.length; ++i) {
            if (indexNames[i] == null) {
                throw new IllegalArgumentException("null index name " + i);
            }
            String indexName = indexNames[i].trim();
            if (indexName.length() == 0) {
                throw new IllegalArgumentException("empty index name " + i);
            }
            if (!rowType.containsKey(indexName)) {
                throw new OpenDataException("no item name " + indexName);
            }
            this.indexNames.add(indexName);
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return Collections.unmodifiableList(this.indexNames);
    }

    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof TabularData)) {
            return false;
        }
        TabularType other = ((TabularData)obj).getTabularType();
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TabularType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TabularType other = (TabularType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (!this.getRowType().equals(other.getRowType())) {
            return false;
        }
        Iterator thisNames = this.getIndexNames().iterator();
        Iterator otherNames = other.getIndexNames().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = (String)thisNames.next();
            if (thisName.equals(otherName = (String)otherNames.next())) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode();
        this.cachedHashCode += this.getRowType().hashCode();
        Iterator i = this.indexNames.iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": typeName=[");
        buffer.append(this.getTypeName());
        buffer.append("] rowType=[");
        buffer.append(this.getRowType());
        buffer.append("] indexNames=[");
        Iterator thisNames = this.getIndexNames().iterator();
        while (thisNames.hasNext()) {
            buffer.append(thisNames.next());
            if (!thisNames.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

