/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class TdkI18n {
    private static Logger _logger = Logger.getLogger(TdkI18n.class);
    protected Locale _currentLocale = null;
    protected ResourceBundle _appBundle = null;
    protected ResourceBundle _defaultBundle = null;

    public TdkI18n(String string) {
        this._defaultBundle = ResourceBundle.getBundle(string + ".JVIPE_I18n");
    }

    public Locale getLocale() {
        this.checkUp();
        return this._currentLocale;
    }

    public void setLocale(String string, String string2) {
        this._appBundle = null;
        this._currentLocale = new Locale(string, string2);
        this.checkUp();
    }

    public String getString(String string) {
        this.checkUp();
        if (this._appBundle != null) {
            try {
                return this._appBundle.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return this._defaultBundle.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getString(String string, Object[] objectArray) {
        this.checkUp();
        String string2 = this.getString(string);
        if (string2 == null) {
            return null;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this._currentLocale);
        messageFormat.applyPattern(string2);
        return messageFormat.format(objectArray);
    }

    protected void checkUp() {
        boolean bl;
        boolean bl2 = this._currentLocale == null;
        boolean bl3 = bl = bl2 || this._appBundle == null;
        if (bl2) {
            this._currentLocale = Locale.getDefault();
        }
        if (bl) {
            try {
                this._appBundle = ResourceBundle.getBundle("JVIPE_I18n", this._currentLocale);
            }
            catch (Exception exception) {
                this._appBundle = null;
            }
        }
    }
}

