/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.algorithms;

import com.vividsolutions.jts.geom.Coordinate;
import org.apache.log4j.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.tecgraf.jtdk.core.TdkJavaProcessingService;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.swig.TeDatum;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionFactory;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;

public class TdkCalcOrthodromicDistance {
    private static Logger _logger;
    private static TdkJavaProcessingService _service;
    private static TeProjection _wgs84;

    public static double calcDistanceInMeters(Coordinate coordinate, Coordinate coordinate2) throws TdkInvalidParamValueException {
        double d;
        if (coordinate == null || coordinate2 == null) {
            return 0.0;
        }
        try {
            d = JTS.orthodromicDistance((Coordinate)coordinate, (Coordinate)coordinate2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (ArithmeticException arithmeticException) {
            return 2.0E7;
        }
        catch (TransformException transformException) {
            String string = new String("Invalid param: a coordinate could not be transformed by Geotools: " + coordinate + ";" + coordinate2);
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        return d;
    }

    public static double calcDistanceInMeters(Coordinate coordinate, Coordinate coordinate2, TeProjection teProjection) throws TdkInvalidParamValueException {
        Coordinate coordinate3 = _service.convertCoord(coordinate, teProjection, _wgs84);
        Coordinate coordinate4 = _service.convertCoord(coordinate2, teProjection, _wgs84);
        return TdkCalcOrthodromicDistance.calcDistanceInMeters(coordinate3, coordinate4);
    }

    static {
        _service = new TdkJavaProcessingService();
        _logger = Logger.getLogger(TdkCalcOrthodromicDistance.class);
        TeProjectionParams teProjectionParams = new TeProjectionParams();
        teProjectionParams.setName("LatLong");
        teProjectionParams.setDatum(new TeDatum("WGS84"));
        _wgs84 = TeProjectionFactory.make(teProjectionParams);
    }
}

