/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.data;

import java.util.Date;
import java.util.Vector;
import org.tecgraf.jtdk.core.data.TdkTable;
import org.tecgraf.jtdk.core.data.TdkTableDataTypes;

public class TdkMemoryTable
implements TdkTable {
    protected Vector<Vector<Object>> _table = new Vector();
    protected Vector<String> _columnNames = new Vector();
    protected Vector<Integer> _columnTypes = new Vector();
    protected int _numRows = 0;
    protected int _numColumns = 0;

    public static TdkTable makeMemoryCopyOf(TdkTable tdkTable) {
        int n;
        if (tdkTable == null) {
            return null;
        }
        int n2 = tdkTable.numCols();
        int n3 = tdkTable.numRows();
        if (tdkTable instanceof TdkMemoryTable) {
            boolean bl = true;
            for (n = 0; n < n2; ++n) {
                int n4 = tdkTable.columnType(n);
                if (n4 == 1 || n4 == 2 || n4 == 3 || n4 == 4 || n4 == 5) continue;
                bl = false;
            }
            if (bl) {
                try {
                    TdkMemoryTable tdkMemoryTable = new TdkMemoryTable();
                    TdkMemoryTable tdkMemoryTable2 = (TdkMemoryTable)tdkTable;
                    tdkMemoryTable._table = new Vector<Vector<Object>>(tdkMemoryTable2._table);
                    tdkMemoryTable._columnNames = new Vector<String>(tdkMemoryTable2._columnNames);
                    tdkMemoryTable._columnTypes = new Vector<Integer>(tdkMemoryTable2._columnTypes);
                    tdkMemoryTable._numRows = tdkMemoryTable2._numRows;
                    tdkMemoryTable._numColumns = tdkMemoryTable2._numColumns;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        TdkMemoryTable tdkMemoryTable = new TdkMemoryTable();
        for (n = 0; n < n2; ++n) {
            tdkMemoryTable.addColumn(tdkTable.columnName(n), tdkTable.columnType(n));
        }
        tdkMemoryTable.addRows(n3);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                tdkMemoryTable.setElement(TdkTableDataTypes.makeMemoryCopyOf(tdkTable.getElement(n, i)), n, i);
            }
        }
        return tdkMemoryTable;
    }

    @Override
    public int numCols() {
        return this._numColumns;
    }

    @Override
    public int numRows() {
        return this._numRows;
    }

    @Override
    public void addColumn(String string, int n) {
        this.addColumn(string, n, this._numColumns, null);
    }

    @Override
    public void addColumn(String string, int n, int n2) {
        this.addColumn(string, n, n2, null);
    }

    @Override
    public void addColumn(String string, int n, int n2, Object object) {
        if (string == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n2 < 0 || n2 > this._numColumns) {
            return;
        }
        if (object != null && TdkTableDataTypes.getType(object) != n) {
            return;
        }
        for (int i = 0; i < this._numRows; ++i) {
            Vector<Object> vector = this._table.get(i);
            vector.add(n2, object);
        }
        this._columnNames.add(n2, string);
        this._columnTypes.add(n2, new Integer(n));
        ++this._numColumns;
    }

    @Override
    public void removeColumn(int n) {
        if (n < 0 || n >= this._numColumns) {
            return;
        }
        for (int i = 0; i < this._numRows; ++i) {
            Vector<Object> vector = this._table.get(i);
            vector.remove(n);
        }
        this._columnNames.remove(n);
        this._columnTypes.remove(n);
        --this._numColumns;
    }

    @Override
    public void removeColumn(String string) {
        int n = this.columnIndex(string);
        if (n >= 0) {
            this.removeColumn(n);
        }
    }

    @Override
    public int addRow() {
        this.addRows(1, this._numRows);
        return this._numRows - 1;
    }

    @Override
    public void addRow(int n) {
        this.addRows(1, n);
    }

    @Override
    public int addRows(int n) {
        this.addRows(n, this._numRows);
        return this._numRows - n;
    }

    @Override
    public void addRows(int n, int n2) {
        if (n < 1) {
            return;
        }
        if (n2 < 0 || n2 > this._numRows) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this._table.add(n2 + i, this.createEmptyRow());
        }
        this._numRows += n;
    }

    private Vector<Object> createEmptyRow() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this._numColumns; ++i) {
            vector.add(null);
        }
        return vector;
    }

    @Override
    public void removeRow(int n) {
        if (n < 0 || n >= this._numRows) {
            return;
        }
        this._table.remove(n);
        --this._numRows;
    }

    @Override
    public boolean hasColumn(String string) {
        return this.columnIndex(string) >= 0;
    }

    @Override
    public boolean hasColumnWithType(String string, int n) {
        if (n < 0) {
            return false;
        }
        int n2 = this.columnIndex(string);
        if (n2 >= 0) {
            return this._columnTypes.get(n2) == n;
        }
        return false;
    }

    @Override
    public int columnIndex(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this._numColumns; ++i) {
            if (!string.equals(this._columnNames.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String columnName(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this._numColumns) {
            return null;
        }
        return this._columnNames.get(n);
    }

    @Override
    public int columnType(int n) {
        if (n < 0) {
            return -1;
        }
        if (n >= this._numColumns) {
            return -1;
        }
        return this._columnTypes.get(n);
    }

    @Override
    public Object getElement(int n, int n2) {
        if (n2 < 0 || n2 >= this._numColumns) {
            return null;
        }
        if (n < 0 || n >= this._numRows) {
            return null;
        }
        return this._table.get(n).get(n2);
    }

    @Override
    public Object getElement(int n, String string) {
        return this.getElement(n, this.columnIndex(string));
    }

    @Override
    public void setElement(Object object, int n, int n2) {
        if (n2 < 0 || n2 >= this._numColumns) {
            return;
        }
        if (n < 0 || n >= this._numRows) {
            return;
        }
        if (object != null && TdkTableDataTypes.getType(object) != this._columnTypes.get(n2)) {
            return;
        }
        this._table.get(n).set(n2, object);
    }

    @Override
    public void setIntElement(int n, int n2, int n3) {
        this.setElement(new Integer(n), n2, n3);
    }

    @Override
    public void setRealElement(double d, int n, int n2) {
        this.setElement(new Double(d), n, n2);
    }

    @Override
    public void setBoolElement(boolean bl, int n, int n2) {
        this.setElement(new Boolean(bl), n, n2);
    }

    @Override
    public void setStringElement(String string, int n, int n2) {
        this.setElement(string, n, n2);
    }

    @Override
    public void setDateElement(Date date, int n, int n2) {
        this.setElement(date, n, n2);
    }
}

