/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.data;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Date;
import java.util.Vector;
import org.tecgraf.jtdk.core.data.TdkTable;

public class TdkTableDataTypes {
    public static final int TdkNullType = 0;
    public static final int TdkInteger = 1;
    public static final int TdkReal = 2;
    public static final int TdkBoolean = 3;
    public static final int TdkString = 4;
    public static final int TdkDate = 5;
    private static final String[] typeNames = new String[]{"Undefined", "Integer", "Real", "Boolean", "String", "Date"};

    public static int getType(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getPackage().getName();
        String string2 = clazz.getSimpleName();
        if (string.equals("java.lang")) {
            if (string2.equals("Integer")) {
                return 1;
            }
            if (string2.equals("Double")) {
                return 2;
            }
            if (string2.equals("Boolean")) {
                return 3;
            }
            if (string2.equals("String")) {
                return 4;
            }
        } else if (string.equals("java.util") && string2.equals("Date")) {
            return 5;
        }
        return 0;
    }

    public static String getTypeName(int n) {
        if (n <= 0 || n >= typeNames.length) {
            return typeNames[0];
        }
        return typeNames[n];
    }

    public static int getTypeByName(String string) {
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            if (!string.equalsIgnoreCase(typeNames[i])) continue;
            return i;
        }
        return 0;
    }

    public static int getElementType(Vector<?> vector) {
        if (vector == null) {
            return 0;
        }
        Class<?> clazz = vector.getClass();
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        String string = "";
        if (typeVariableArray.length > 0) {
            string = typeVariableArray[0].getName();
            Type[] typeArray = typeVariableArray[0].getBounds();
            if (typeArray.length > 0) {
                string = typeArray[0].toString();
                string = typeArray[0].getClass().getName();
            }
        }
        return 0;
    }

    public static Integer integerValue(Object object) {
        if (TdkTableDataTypes.getType(object) != 1) {
            return null;
        }
        return (Integer)object;
    }

    public static Double realValue(Object object) {
        if (TdkTableDataTypes.getType(object) != 2) {
            return null;
        }
        return (Double)object;
    }

    public static Boolean booleanValue(Object object) {
        if (TdkTableDataTypes.getType(object) != 3) {
            return null;
        }
        return (Boolean)object;
    }

    public static String stringValue(Object object) {
        if (TdkTableDataTypes.getType(object) != 4) {
            return null;
        }
        return (String)object;
    }

    public static Date dateValue(Object object) {
        if (TdkTableDataTypes.getType(object) != 5) {
            return null;
        }
        return (Date)object;
    }

    public static Object makeMemoryCopyOf(Object object) {
        if (object == null) {
            return null;
        }
        int n = TdkTableDataTypes.getType(object);
        switch (n) {
            case 1: {
                return TdkTableDataTypes.integerValue(object);
            }
            case 2: {
                return TdkTableDataTypes.realValue(object);
            }
            case 3: {
                return TdkTableDataTypes.booleanValue(object);
            }
            case 4: {
                return TdkTableDataTypes.stringValue(object);
            }
            case 5: {
                try {
                    return TdkTableDataTypes.dateValue(object).clone();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean areEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        int n = TdkTableDataTypes.getType(object);
        if (n == 0) {
            return false;
        }
        if (n != TdkTableDataTypes.getType(object2)) {
            return false;
        }
        switch (n) {
            case 1: {
                return TdkTableDataTypes.integerValue(object).equals(TdkTableDataTypes.integerValue(object2));
            }
            case 2: {
                return TdkTableDataTypes.realValue(object).equals(TdkTableDataTypes.realValue(object2));
            }
            case 3: {
                return TdkTableDataTypes.booleanValue(object).equals(TdkTableDataTypes.booleanValue(object2));
            }
            case 4: {
                return TdkTableDataTypes.stringValue(object).equals(TdkTableDataTypes.stringValue(object2));
            }
            case 5: {
                return TdkTableDataTypes.dateValue(object).equals(TdkTableDataTypes.dateValue(object2));
            }
        }
        return false;
    }

    public static boolean areTablesEqual(TdkTable tdkTable, TdkTable tdkTable2) {
        return false;
    }
}

