/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.model.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.model.utils.TdkInvalidStyleLibrarySerializationVersion;
import org.tecgraf.jtdk.core.swig.TdkStyle;
import org.tecgraf.jtdk.core.swig.TdkStyleFactory;
import org.tecgraf.jtdk.core.swig.TdkStyleLibrary;
import org.tecgraf.jtdk.core.swig.TdkStyleLibraryVector;
import org.tecgraf.jtdk.core.swig.TdkStyleVector;

public class TdkStyleLibrarySerializer {
    private static final String LIBRARY_VECTOR_VERSION = "1.0";
    private static final String LIBRARY_VERSION = "1.0";
    static Logger _logger = Logger.getLogger(TdkStyleLibrarySerializer.class);

    public static ByteArrayOutputStream serializeStyleLibraryVector(TdkStyleLibraryVector tdkStyleLibraryVector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF("1.0");
        dataOutputStream.writeInt((int)tdkStyleLibraryVector.size());
        int n = 0;
        while ((long)n < tdkStyleLibraryVector.size()) {
            TdkStyleLibrary tdkStyleLibrary = tdkStyleLibraryVector.get(n);
            ByteArrayOutputStream byteArrayOutputStream2 = TdkStyleLibrarySerializer.serialiazeStyleLibrary(tdkStyleLibrary);
            byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
            ++n;
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream;
    }

    public static ByteArrayOutputStream serialiazeStyleLibrary(TdkStyleLibrary tdkStyleLibrary) throws IOException {
        Object object;
        TdkStyleVector tdkStyleVector = tdkStyleLibrary.getStyles();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF("1.0");
        dataOutputStream.writeUTF(tdkStyleLibrary.getName());
        dataOutputStream.writeInt((int)tdkStyleVector.size());
        int n = 0;
        while ((long)n < tdkStyleVector.size()) {
            object = tdkStyleVector.get(n);
            byte[] byArray = ((TdkStyle)object).toByteArray();
            String string = ((TdkStyle)object).getName();
            if (string == null) {
                string = "";
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(((TdkStyle)object).getType());
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            _logger.debug((Object)("Style: " + ((TdkStyle)object).getName()));
            _logger.debug((Object)("Style blob size: " + byArray.length));
            ++n;
        }
        dataOutputStream.flush();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        object = new DataOutputStream(byteArrayOutputStream2);
        ((FilterOutputStream)object).write(byteArrayOutputStream.toByteArray());
        return byteArrayOutputStream2;
    }

    public static TdkStyleLibraryVector deserializeStyleLibraryVector(FileInputStream fileInputStream) throws IOException, TdkInvalidStyleLibrarySerializationVersion {
        TdkStyleLibraryVector tdkStyleLibraryVector = new TdkStyleLibraryVector();
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        String string = dataInputStream.readUTF();
        if (!string.equals("1.0")) {
            throw new TdkInvalidStyleLibrarySerializationVersion("1.0", string);
        }
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            TdkStyleLibrary tdkStyleLibrary = TdkStyleLibrarySerializer.deserializeStyleLibrary(dataInputStream);
            tdkStyleLibraryVector.add(tdkStyleLibrary);
            tdkStyleLibrary.setToFreeNativeTarget(false);
        }
        return tdkStyleLibraryVector;
    }

    public static TdkStyleLibrary deserializeStyleLibrary(DataInputStream dataInputStream) throws IOException, TdkInvalidStyleLibrarySerializationVersion {
        TdkStyleLibrary tdkStyleLibrary = new TdkStyleLibrary();
        String string = dataInputStream.readUTF();
        if (!string.equals("1.0")) {
            throw new TdkInvalidStyleLibrarySerializationVersion("1.0", string);
        }
        String string2 = dataInputStream.readUTF();
        tdkStyleLibrary.setName(string2);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string3 = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            dataInputStream.read(byArray);
            TdkStyle tdkStyle = null;
            tdkStyle = TdkStyleFactory.makeStyle(byArray, n2);
            tdkStyle.setName(string3);
            if (tdkStyle == null) continue;
            tdkStyleLibrary.addStyle(tdkStyle);
            tdkStyle.setToFreeNativeTarget(false);
        }
        return tdkStyleLibrary;
    }
}

