/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.application.test.buttons;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.tecgraf.jtdk.desktop.application.test.buttons.ButtonHelper;

public final class PushButton
extends JButton {
    private static final long serialVersionUID = -3973365347532594018L;
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    static final Dimension SIZE = new Dimension(23, 22);
    private ButtonHelper.MouseHandler mouseHandler;

    public PushButton(Icon icon) {
        super(icon);
        this.init();
    }

    public PushButton(Action action) {
        super(action);
        this.init();
    }

    public PushButton() {
        this.init();
    }

    private void init() {
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(this.getMouseHandler());
        this.addMouseMotionListener(this.getMouseHandler());
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !PushButton.this.isShowing()) {
                    PushButton.this.getMouseHandler().reset();
                }
            }
        });
    }

    private ButtonHelper.MouseHandler getMouseHandler() {
        if (this.mouseHandler == null) {
            this.mouseHandler = ButtonHelper.createMouseHandler(this);
        }
        return this.mouseHandler;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.getMouseHandler().isMouseIn();
        if (this.isEnabled() && bl2 && bl) {
            ButtonHelper.paintPressedBorder(graphics, this);
        }
        super.paintComponent(graphics);
        if (this.isEnabled() && bl2 && !bl) {
            ButtonHelper.paintHoverBorder(graphics, this);
        }
    }

    @Override
    public final Insets getInsets() {
        return INSETS;
    }

    @Override
    public final Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    public final Dimension getMinimumSize() {
        return SIZE;
    }

    @Override
    public final Dimension getPreferredSize() {
        return SIZE;
    }
}

