/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.application.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkDefaultInitializer;
import org.tecgraf.jtdk.core.TdkJVipeSetup;
import org.tecgraf.jtdk.core.exceptions.TdkActionWorkflowServiceNotInitializedException;
import org.tecgraf.jtdk.core.swig.StringVector;
import org.tecgraf.jtdk.core.swig.TdkAbstractGraphicsCardsInfo;
import org.tecgraf.jtdk.core.swig.TdkConDescriptor;
import org.tecgraf.jtdk.core.swig.TdkGraphicsCardsInfoFactory;
import org.tecgraf.jtdk.core.swig.TdkLayerGID;
import org.tecgraf.jtdk.core.swig.TdkLayout;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.TdkTheme;
import org.tecgraf.jtdk.core.swig.TdkThemeGID;
import org.tecgraf.jtdk.core.swig.TdkViewGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGID;
import org.tecgraf.jtdk.core.swig.TdkViewNodeGIDVector;
import org.tecgraf.jtdk.core.swig.TeDBConnectionsPool;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.desktop.application.test.TdkDefaultCreatePointActionHandler;
import org.tecgraf.jtdk.desktop.application.test.TdkDefaultCreateTextActionHandler;
import org.tecgraf.jtdk.desktop.application.test.TdkImageMapElement;
import org.tecgraf.jtdk.desktop.application.test.buttons.PushButton;
import org.tecgraf.jtdk.desktop.application.test.buttons.ToggleButton;
import org.tecgraf.jtdk.desktop.components.TdkComponentsInitializer;
import org.tecgraf.jtdk.desktop.components.TdkObjectSelectionContext;
import org.tecgraf.jtdk.desktop.components.defaultmodule.TdkDefaultApplicationModule;
import org.tecgraf.jtdk.desktop.components.defaultmodule.map.menu.elements.TdkDefaultFitSelectedObjectsMenuElement;
import org.tecgraf.jtdk.desktop.components.defaultmodule.map.menu.elements.TdkDefaultFitViewMenuElement;
import org.tecgraf.jtdk.desktop.components.defaultmodule.map.menu.elements.TdkDefaultObjectIdentificationMenuElement;
import org.tecgraf.jtdk.desktop.components.layout.TdkLayoutDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapDisplay;
import org.tecgraf.jtdk.desktop.components.map.TdkMapElement;
import org.tecgraf.jtdk.desktop.components.map.TdkMenuElement;
import org.tecgraf.jtdk.desktop.components.map.TdkNavigationToolBar;
import org.tecgraf.jtdk.desktop.components.map.statusbar.TdkStatusBar;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkAbstractCreatePointActionHandler;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkAbstractCreateTextActionHandler;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkCreatePointTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkCreateTextTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkInteractorTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPickCircleTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkPickTool;
import org.tecgraf.jtdk.desktop.components.map.tool.TdkTool;
import org.tecgraf.jtdk.desktop.components.treeview.TdkLegendElementFactory;
import org.tecgraf.jtdk.desktop.components.treeview.TdkTreeView;

public class TdkJvipeTestApp
implements WindowListener,
ActionListener {
    private static Logger _logger = Logger.getLogger(TdkJvipeTestApp.class);
    private static final String CREATE_POINT = "Create Point";
    private static final String TITLE = "JVipe prototype New";
    private static final String LAYOUT = "Layout...";
    private static final String EDIT_PROJECTION = "Edit Projection";
    private static final String IMPORT_SHAPE_FILE = "Import Shape File";
    private static final String CONNECT_TO_ACCESS_DB = "Connect to Access DB";
    private static final String CREATE_TEXT = "Create Text";
    private static final String CREATE_DATABASE = "Create Database";
    private TdkDefaultApplicationModule _module;
    private TdkConDescriptor _descriptor;
    private TeProjection _projection;
    private TdkCreatePointTool _createPointTool;
    private TdkCreateTextTool _createTextTool;

    public TdkJvipeTestApp(TdkDefaultApplicationModule tdkDefaultApplicationModule) {
        this._module = tdkDefaultApplicationModule;
    }

    public static String getFormattedGraphicCardsNames() {
        TdkGraphicsCardsInfoFactory tdkGraphicsCardsInfoFactory = new TdkGraphicsCardsInfoFactory();
        TdkAbstractGraphicsCardsInfo tdkAbstractGraphicsCardsInfo = tdkGraphicsCardsInfoFactory.build();
        StringVector stringVector = tdkAbstractGraphicsCardsInfo.getCurrentGraphicsCardsNames();
        long l = stringVector.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Found " + l + " graphic card");
        stringBuffer.append(l > 1L ? "s: " : (l > 0L ? ": " : ""));
        int n = 0;
        while ((long)n < l) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"" + stringVector.get(n) + "\"");
            ++n;
        }
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = new File(".");
            System.out.println("Current Directory : \"" + ((File)object).getCanonicalPath() + "\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = ".." + File.separator + ".." + File.separator + ".." + File.separator + "resources" + File.separator + "OpenGL" + File.separator + "textures";
        TdkDefaultInitializer tdkDefaultInitializer = new TdkDefaultInitializer();
        tdkDefaultInitializer.initializeTdkLogParams(TdkDefaultInitializer.LOG_INFO);
        TdkComponentsInitializer.initialize();
        _logger.info((Object)TdkJvipeTestApp.getFormattedGraphicCardsNames());
        TdkMapDisplay tdkMapDisplay = new TdkMapDisplay();
        tdkMapDisplay.setPreferredSize(new Dimension(500, 500));
        tdkMapDisplay.addElement((TdkMapElement)new TdkImageMapElement(), 0);
        TdkNavigationToolBar tdkNavigationToolBar = new TdkNavigationToolBar(tdkMapDisplay){

            protected JButton createJButton() {
                return new PushButton();
            }

            protected JToggleButton createToggleButton() {
                return new ToggleButton();
            }
        };
        tdkNavigationToolBar.initDefaultTools(tdkMapDisplay);
        TdkCreatePointTool tdkCreatePointTool = new TdkCreatePointTool(tdkMapDisplay, (TdkAbstractCreatePointActionHandler)new TdkDefaultCreatePointActionHandler(tdkMapDisplay));
        AbstractButton abstractButton = tdkNavigationToolBar.add((TdkTool)tdkCreatePointTool);
        TdkCreateTextTool tdkCreateTextTool = new TdkCreateTextTool(tdkMapDisplay, (TdkAbstractCreateTextActionHandler)new TdkDefaultCreateTextActionHandler(tdkMapDisplay));
        AbstractButton abstractButton2 = tdkNavigationToolBar.add((TdkTool)tdkCreateTextTool);
        TdkTreeView tdkTreeView = new TdkTreeView(new TdkLegendElementFactory());
        TdkObjectSelectionContext tdkObjectSelectionContext = new TdkObjectSelectionContext();
        TdkDefaultApplicationModule tdkDefaultApplicationModule = new TdkDefaultApplicationModule(tdkMapDisplay, tdkTreeView, tdkObjectSelectionContext, tdkNavigationToolBar);
        TdkPickTool tdkPickTool = new TdkPickTool(tdkMapDisplay, tdkObjectSelectionContext);
        TdkDefaultFitViewMenuElement tdkDefaultFitViewMenuElement = new TdkDefaultFitViewMenuElement(tdkDefaultApplicationModule);
        tdkMapDisplay.addMenuElement((TdkMenuElement)tdkDefaultFitViewMenuElement, 0);
        TdkDefaultFitSelectedObjectsMenuElement tdkDefaultFitSelectedObjectsMenuElement = new TdkDefaultFitSelectedObjectsMenuElement(tdkDefaultApplicationModule);
        tdkMapDisplay.addMenuElement((TdkMenuElement)tdkDefaultFitSelectedObjectsMenuElement, 1);
        TdkDefaultObjectIdentificationMenuElement tdkDefaultObjectIdentificationMenuElement = new TdkDefaultObjectIdentificationMenuElement(tdkDefaultApplicationModule);
        tdkMapDisplay.addMenuElement((TdkMenuElement)tdkDefaultObjectIdentificationMenuElement, 10);
        tdkNavigationToolBar.setDefaultTool((TdkInteractorTool)tdkPickTool);
        tdkNavigationToolBar.add((TdkTool)new TdkPickCircleTool(tdkMapDisplay, tdkObjectSelectionContext));
        TdkJvipeTestApp tdkJvipeTestApp = new TdkJvipeTestApp(tdkDefaultApplicationModule);
        abstractButton.setActionCommand(CREATE_POINT);
        abstractButton.addActionListener(tdkJvipeTestApp);
        tdkJvipeTestApp.setCreatePointTool(tdkCreatePointTool);
        abstractButton2.setActionCommand(CREATE_TEXT);
        abstractButton2.addActionListener(tdkJvipeTestApp);
        tdkJvipeTestApp.setCreateTextTool(tdkCreateTextTool);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Connect DB");
        JMenuItem jMenuItem = new JMenuItem(CONNECT_TO_ACCESS_DB);
        jMenuItem.addActionListener(tdkJvipeTestApp);
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(IMPORT_SHAPE_FILE);
        jMenuItem2.addActionListener(tdkJvipeTestApp);
        JMenuItem jMenuItem3 = new JMenuItem(EDIT_PROJECTION);
        jMenuItem3.addActionListener(tdkJvipeTestApp);
        jMenu.add(jMenu2);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(CREATE_DATABASE);
        jMenuItem4.addActionListener(tdkJvipeTestApp);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(LAYOUT);
        jMenuItem5.addActionListener(tdkJvipeTestApp);
        jMenu.add(jMenuItem5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)tdkMapDisplay, "Center");
        TdkStatusBar tdkStatusBar = new TdkStatusBar();
        tdkStatusBar.buildDefaultStatusBar(tdkMapDisplay);
        jPanel.add((Component)tdkStatusBar.getContentPane(), "South");
        JFrame jFrame = new JFrame();
        jFrame.setTitle(TITLE);
        JScrollPane jScrollPane = new JScrollPane((Component)tdkTreeView);
        jScrollPane.setPreferredSize(new Dimension(300, 500));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel);
        jSplitPane.setDividerLocation(0.3334);
        jFrame.setLayout(new BorderLayout());
        jFrame.setJMenuBar(jMenuBar);
        jFrame.add((Component)tdkNavigationToolBar, "North");
        jFrame.add((Component)jSplitPane, "Center");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        jFrame.addWindowListener(tdkJvipeTestApp);
    }

    private void connectWithSqlServer() {
        TdkConDescriptor tdkConDescriptor = TdkConDescriptor.createConDescriptor((String)"SqlServerAdo;Caju,1695;RODNEI_MAPA;infopae;infopae_");
        TeDBConnectionsPool.connectDatabase((String)tdkConDescriptor.getDbKey());
        TdkViewGID tdkViewGID = new TdkViewGID(tdkConDescriptor.getDbKey(), 1);
        tdkViewGID.getIdStr();
        this._module.setView(tdkViewGID);
        this._module.getDisplay().redraw();
        this._projection = TdkSetup.getPersistenceService().getView(tdkViewGID).getProjection();
    }

    private void setCreateTextTool(TdkCreateTextTool tdkCreateTextTool) {
        this._createTextTool = tdkCreateTextTool;
    }

    private void setCreatePointTool(TdkCreatePointTool tdkCreatePointTool) {
        this._createPointTool = tdkCreatePointTool;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this._module.getDisplay().redraw();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            TdkViewGID tdkViewGID;
            TdkConDescriptor tdkConDescriptor;
            if (string.equals(CONNECT_TO_ACCESS_DB) && (tdkConDescriptor = TdkJVipeSetup.getInstance().getActionWorkflowService().connectToAccessDatabase()) != null) {
                this._descriptor = tdkConDescriptor;
                TeDBConnectionsPool.connectDatabase((String)this._descriptor.getDbKey());
                tdkViewGID = new TdkViewGID(this._descriptor.getDbKey(), 1);
                tdkViewGID.getIdStr();
                this._module.setView(tdkViewGID);
                this._module.getDisplay().redraw();
                this._projection = TdkSetup.getPersistenceService().getView(tdkViewGID).getProjection();
            }
            if (!string.equals(CREATE_DATABASE)) {
                if (string.equals(IMPORT_SHAPE_FILE)) {
                    TdkJVipeSetup.getInstance().getActionWorkflowService().importShapeFile(this._descriptor);
                } else if (string.equals(EDIT_PROJECTION)) {
                    this._projection = TdkJVipeSetup.getInstance().getActionWorkflowService().editProjection(this._projection);
                } else if (string.equals(LAYOUT)) {
                    tdkConDescriptor = new TdkLayout();
                    tdkViewGID = new TdkLayoutDisplay((TdkLayout)tdkConDescriptor);
                    tdkViewGID.clear();
                    tdkViewGID.setPreferredSize(new Dimension(500, 500));
                    JFrame jFrame = new JFrame("Layout");
                    jFrame.add((Component)tdkViewGID);
                    jFrame.pack();
                    jFrame.setVisible(true);
                } else if (string.equals(CREATE_POINT)) {
                    TdkViewNodeGID tdkViewNodeGID;
                    tdkConDescriptor = this._module.getView();
                    tdkViewGID = TdkSetup.getPersistenceService().getView((TdkViewGID)tdkConDescriptor);
                    TdkViewNodeGIDVector tdkViewNodeGIDVector = tdkViewGID.getViewNodeIdVector();
                    TdkTheme tdkTheme = null;
                    TdkThemeGID tdkThemeGID = null;
                    int n = 0;
                    while ((long)n < tdkViewNodeGIDVector.size()) {
                        tdkViewNodeGID = tdkViewNodeGIDVector.get(n);
                        if (tdkViewNodeGID instanceof TdkThemeGID) {
                            tdkThemeGID = (TdkThemeGID)tdkViewNodeGID;
                            TdkTheme tdkTheme2 = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
                            if (tdkTheme2.isVisible()) {
                                tdkTheme = tdkTheme2;
                                break;
                            }
                        }
                        ++n;
                    }
                    if (tdkTheme != null) {
                        n = tdkTheme.getLayerId();
                        tdkViewNodeGID = new TdkLayerGID(tdkThemeGID.getDBKey(), n);
                        this._createPointTool.setLayerGID((TdkLayerGID)tdkViewNodeGID);
                    }
                } else if (string.equals(CREATE_TEXT)) {
                    TdkViewNodeGID tdkViewNodeGID;
                    tdkConDescriptor = this._module.getView();
                    tdkViewGID = TdkSetup.getPersistenceService().getView((TdkViewGID)tdkConDescriptor);
                    TdkViewNodeGIDVector tdkViewNodeGIDVector = tdkViewGID.getViewNodeIdVector();
                    TdkTheme tdkTheme = null;
                    TdkThemeGID tdkThemeGID = null;
                    int n = 0;
                    while ((long)n < tdkViewNodeGIDVector.size()) {
                        tdkViewNodeGID = tdkViewNodeGIDVector.get(n);
                        if (tdkViewNodeGID instanceof TdkThemeGID) {
                            tdkThemeGID = (TdkThemeGID)tdkViewNodeGID;
                            TdkTheme tdkTheme3 = TdkSetup.getPersistenceService().getTheme(tdkThemeGID);
                            if (tdkTheme3.isVisible()) {
                                tdkTheme = tdkTheme3;
                                break;
                            }
                        }
                        ++n;
                    }
                    if (tdkTheme != null) {
                        n = tdkTheme.getLayerId();
                        tdkViewNodeGID = new TdkLayerGID(tdkThemeGID.getDBKey(), n);
                        this._createTextTool.setLayerGID((TdkLayerGID)tdkViewNodeGID);
                    }
                }
            }
        }
        catch (TdkActionWorkflowServiceNotInitializedException tdkActionWorkflowServiceNotInitializedException) {
            tdkActionWorkflowServiceNotInitializedException.printStackTrace();
        }
    }
}

