/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.codehaus.plexus.util.FileUtils;

public class CsvSummaryFileTarget
implements ExecutionTarget {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CSV_COLUMN_SEPARATOR = ",";
    public static final String CSV_COMMENT_MARKER = "#";
    protected String encoding;
    protected Map<ChecksumFile, Map<String, String>> filesHashcodes;
    protected SortedSet<String> algorithms;
    protected File summaryFile;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public CsvSummaryFileTarget(File summaryFile, String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
        this.artifactListeners = artifactListeners;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<ChecksumFile, Map<String, String>>();
        this.algorithms = new TreeSet<String>();
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
        this.algorithms.add(algorithm);
    }

    @Override
    public void close(String subPath) throws ExecutionTargetCloseException {
        StringBuilder sb = new StringBuilder();
        sb.append(CSV_COMMENT_MARKER).append("File");
        for (String string : this.algorithms) {
            sb.append(CSV_COLUMN_SEPARATOR).append(string);
        }
        for (ChecksumFile checksumFile : this.filesHashcodes.keySet()) {
            sb.append(LINE_SEPARATOR).append(checksumFile.getRelativePath(checksumFile, subPath));
            Map<String, String> fileHashcodes = this.filesHashcodes.get(checksumFile);
            for (String algorithm : this.algorithms) {
                sb.append(CSV_COLUMN_SEPARATOR);
                if (!fileHashcodes.containsKey(algorithm)) continue;
                sb.append(fileHashcodes.get(algorithm));
            }
        }
        sb.append(LINE_SEPARATOR);
        FileUtils.mkdir((String)this.summaryFile.getParent());
        try {
            FileUtils.fileWrite((String)this.summaryFile.getPath(), (String)this.encoding, (String)sb.toString());
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(this.summaryFile, "csv");
            }
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
    }
}

