/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.digest.DigesterFactory;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetInitializationException;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetWriteException;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.codehaus.plexus.util.FileUtils;

public class OneHashPerFileTarget
implements ExecutionTarget {
    protected String encoding;
    protected File outputDirectory;
    protected final Iterable<? extends ArtifactListener> artifactListeners;

    public OneHashPerFileTarget(String encoding, File outputDirectory, Iterable<? extends ArtifactListener> artifactListeners) {
        this.encoding = encoding;
        this.outputDirectory = outputDirectory;
        this.artifactListeners = artifactListeners;
    }

    public OneHashPerFileTarget(String encoding, Iterable<? extends ArtifactListener> artifactListeners) {
        this(encoding, null, artifactListeners);
    }

    @Override
    public void init() throws ExecutionTargetInitializationException {
        if (this.outputDirectory != null) {
            if (this.outputDirectory.exists() && !this.outputDirectory.isDirectory()) {
                throw new ExecutionTargetInitializationException("'" + this.outputDirectory.getPath() + "' already exists and is not a directory.");
            }
            this.outputDirectory.mkdirs();
        }
    }

    @Override
    public void write(String digest, ChecksumFile file, String algorithm) throws ExecutionTargetWriteException {
        try {
            File outputFileDirectory = this.outputDirectory != null ? this.outputDirectory : file.getFile().getParentFile();
            String fileExtension = DigesterFactory.getInstance().getFileDigester(algorithm).getFileExtension();
            String outputFileName = file.getFile().getName() + fileExtension;
            File outputFile = new File(outputFileDirectory.getPath(), outputFileName);
            FileUtils.fileWrite((File)outputFile, (String)digest);
            for (ArtifactListener artifactListener : this.artifactListeners) {
                artifactListener.artifactCreated(outputFile, fileExtension);
            }
        }
        catch (IOException e) {
            throw new ExecutionTargetWriteException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExecutionTargetWriteException(e.getMessage());
        }
    }

    @Override
    public void close(String subPath) {
    }
}

