/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tacos.ajax.AjaxFormSupport;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.ResponseBuilder;
import net.sf.tacos.ajax.components.FormMessages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.HiddenFieldData;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.services.ServiceConstants;
import org.apache.tapestry.util.IdAllocator;
import org.apache.tapestry.valid.IValidationDelegate;

public class AjaxFormSupportImpl
implements AjaxFormSupport {
    private static final Log log = LogFactory.getLog((Class)AjaxFormSupportImpl.class);
    public static final String FORM_IDS = "formids";
    public static final String RESERVED_FORM_IDS = "reservedids";
    public static final String SUBMIT_MODE = "submitmode";
    public static final String SCRIPT = "/net/sf/tacos/ajax/components/Form.js";
    private static final Set _standardReservedIds;
    public static final String FIELD_FOCUS_ATTRIBUTE = "org.apache.tapestry.field-focused";
    private static final Set _submitModes;
    private int allocatedIdIndex;
    private final List allocatedIds = new ArrayList();
    private final IRequestCycle cycle;
    protected ResponseBuilder response;
    protected AjaxWebRequest ajaxRequest;
    private final IdAllocator elementIdAllocator = new IdAllocator();
    private String encodingType;
    private final List deferredRunnables = new ArrayList();
    private final Map prerenderMap = new HashMap();
    private Map events;
    private final IForm form;
    private final List hiddenValues = new ArrayList();
    private final boolean rewinding;
    private final IMarkupWriter writer;
    protected IMarkupWriter hiddenWriter;
    private final Resource script;
    private final IValidationDelegate delegate;
    private final PageRenderSupport pageRenderSupport;

    public AjaxFormSupportImpl(IMarkupWriter writer, IRequestCycle cycle, AjaxWebRequest ajaxRequest, IForm form) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)form, (String)"form");
        this.writer = writer;
        this.cycle = cycle;
        this.form = form;
        this.ajaxRequest = ajaxRequest;
        if (ajaxRequest != null && ajaxRequest.isValidRequest()) {
            this.response = ajaxRequest.getResponseBuilder();
        }
        this.delegate = form.getDelegate();
        this.rewinding = cycle.isRewound((IComponent)form);
        this.allocatedIdIndex = 0;
        this.script = new ClasspathResource(cycle.getEngine().getClassResolver(), SCRIPT);
        this.pageRenderSupport = TapestryUtils.getOptionalPageRenderSupport((IRequestCycle)cycle);
    }

    public void addEventHandler(FormEventType type, String functionName) {
        ArrayList<String> functionList;
        if (this.events == null) {
            this.events = new HashMap();
        }
        if ((functionList = (ArrayList<String>)this.events.get(type)) == null) {
            functionList = new ArrayList<String>();
            this.events.put(type, functionList);
        }
        functionList.add(functionName);
    }

    private void addHiddenFieldsForLinkParameters(ILink link) {
        Object[] names = link.getParameterNames();
        int count = Tapestry.size((Object[])names);
        StringBuffer extraIds = new StringBuffer();
        String sep = "";
        boolean hasExtra = false;
        this.preallocateReservedIds();
        for (int i = 0; i < count; ++i) {
            Object name = names[i];
            if (!_standardReservedIds.contains(name)) {
                this.elementIdAllocator.allocateId((String)name);
                extraIds.append(sep);
                extraIds.append((String)name);
                sep = ",";
                hasExtra = true;
            }
            this.addHiddenFieldsForLinkParameter(link, (String)name);
        }
        if (hasExtra) {
            this.addHiddenValue(RESERVED_FORM_IDS, extraIds.toString());
        }
    }

    public void addHiddenValue(String name, String value) {
        this.hiddenValues.add(new HiddenFieldData(name, value));
    }

    public void addHiddenValue(String name, String id, String value) {
        this.hiddenValues.add(new HiddenFieldData(name, id, value));
    }

    private String buildAllocatedIdList() {
        StringBuffer buffer = new StringBuffer();
        int count = this.allocatedIds.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.allocatedIds.get(i));
        }
        return buffer.toString();
    }

    protected void emitEventHandlers(String formId) {
        if (!this.shouldRender()) {
            return;
        }
        if (this.events == null || this.events.isEmpty()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.events.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            FormEventType type = (FormEventType)entry.getKey();
            Object value = entry.getValue();
            buffer.append("dojo.event.connect('before', dojo.byId('").append(formId).append("'), '").append(type.getAddHandlerFunctionName()).append("', ").append("function (event) \n{");
            List l = (List)value;
            int count = l.size();
            for (int j = 0; j < count; ++j) {
                String functionName = (String)l.get(j);
                if (j > 0) {
                    buffer.append(";");
                }
                buffer.append("\n  ");
                buffer.append(functionName);
                if (functionName.endsWith(")")) continue;
                buffer.append("()");
            }
            buffer.append(";\n});\n");
        }
        this.pageRenderSupport.addInitializationScript(buffer.toString());
    }

    protected boolean shouldRender() {
        boolean result = true;
        if (this.ajaxRequest != null && this.ajaxRequest.isValidRequest()) {
            result = this.ajaxRequest.containsComponentId(this.form.getName()) || !NullWriter.class.isInstance(this.writer);
        }
        return result;
    }

    public String getElementId(IFormComponent component) {
        return this.getElementId(component, component.getId());
    }

    public String getElementId(IFormComponent component, String baseId) {
        String filteredId = TapestryUtils.convertTapestryIdToNMToken((String)baseId);
        String result = this.elementIdAllocator.allocateId(filteredId);
        if (this.rewinding) {
            if (this.allocatedIdIndex >= this.allocatedIds.size()) {
                throw new StaleLinkException(FormMessages.formTooManyIds((IComponent)this.form, this.allocatedIds.size(), (IComponent)component), (IComponent)component);
            }
            String expected = (String)this.allocatedIds.get(this.allocatedIdIndex);
            if (!result.equals(expected)) {
                throw new StaleLinkException(FormMessages.formIdMismatch((IComponent)this.form, this.allocatedIdIndex, expected, result, (IComponent)component), (IComponent)component);
            }
        } else {
            this.allocatedIds.add(result);
        }
        ++this.allocatedIdIndex;
        component.setName(result);
        return result;
    }

    public boolean isRewinding() {
        return this.rewinding;
    }

    private void preallocateReservedIds() {
        for (int i = 0; i < ServiceConstants.RESERVED_IDS.length; ++i) {
            this.elementIdAllocator.allocateId(ServiceConstants.RESERVED_IDS[i]);
        }
    }

    private void reinitializeIdAllocatorForRewind() {
        String allocatedFormIds = this.cycle.getParameter(FORM_IDS);
        String[] ids = TapestryUtils.split((String)allocatedFormIds);
        for (int i = 0; i < ids.length; ++i) {
            this.allocatedIds.add(ids[i]);
            log.debug((Object)("form field id being allocated: " + ids[i]));
        }
        this.preallocateReservedIds();
        String extraReservedIds = this.cycle.getParameter(RESERVED_FORM_IDS);
        ids = TapestryUtils.split((String)extraReservedIds);
        for (int i = 0; i < ids.length; ++i) {
            this.elementIdAllocator.allocateId(ids[i]);
        }
    }

    public void render(String method, IRender informalParametersRenderer, ILink link, String scheme) {
        this.render(method, informalParametersRenderer, link, scheme, null);
    }

    public void render(String method, IRender informalParametersRenderer, ILink link, String scheme, Integer port) {
        String formId = this.form.getName();
        this.emitEventManagerInitialization(formId);
        this.addHiddenFieldsForLinkParameters(link);
        this.addHiddenValue(SUBMIT_MODE, null);
        this.addHiddenValue("submitname", null);
        NestedMarkupWriter nested = this.writer.getNestedWriter();
        this.form.renderBody((IMarkupWriter)nested, this.cycle);
        this.runDeferredRunnables();
        int portI = port == null ? 0 : port;
        this.writeTag(this.writer, method, link.getURL(scheme, null, portI, null, false));
        this.writer.attribute("name", formId);
        this.writer.attribute("id", formId);
        if (this.encodingType != null) {
            this.writer.attribute("enctype", this.encodingType);
        }
        this.emitEventHandlers(formId);
        informalParametersRenderer.render(this.writer, this.cycle);
        this.writer.println();
        this.writeHiddenFields();
        nested.close();
        this.writer.end();
        String fieldId = this.delegate.getFocusField();
        if (fieldId == null || this.pageRenderSupport == null) {
            return;
        }
        if (!this.form.getFocus() || this.cycle.getAttribute(FIELD_FOCUS_ATTRIBUTE) != null) {
            return;
        }
        if (!this.shouldRender()) {
            fieldId = this.ajaxRequest.getFocusElement();
        }
        if (fieldId != null) {
            this.pageRenderSupport.addInitializationScript("Tapestry.set_focus('" + fieldId + "');");
        }
        this.cycle.setAttribute(FIELD_FOCUS_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    protected void emitEventManagerInitialization(String formId) {
        if (this.pageRenderSupport == null) {
            return;
        }
        if (this.shouldRender()) {
            this.pageRenderSupport.addExternalScript(this.script);
            this.pageRenderSupport.addInitializationScript("Tapestry.register_form('" + formId + "');");
        }
    }

    public String rewind() {
        this.form.getDelegate().clear();
        String mode = this.cycle.getParameter(SUBMIT_MODE);
        if ("cancel".equals(mode)) {
            return mode;
        }
        this.reinitializeIdAllocatorForRewind();
        this.form.renderBody(this.writer, this.cycle);
        int expected = this.allocatedIds.size();
        if (this.allocatedIdIndex < expected) {
            String nextExpectedId = (String)this.allocatedIds.get(this.allocatedIdIndex);
            throw new StaleLinkException(FormMessages.formTooFewIds((IComponent)this.form, expected - this.allocatedIdIndex, nextExpectedId), (IComponent)this.form);
        }
        this.runDeferredRunnables();
        if (_submitModes.contains(mode)) {
            return mode;
        }
        return "submit";
    }

    private void runDeferredRunnables() {
        Iterator i = this.deferredRunnables.iterator();
        while (i.hasNext()) {
            Runnable r = (Runnable)i.next();
            r.run();
        }
    }

    public void setEncodingType(String encodingType) {
        if (this.encodingType != null && !this.encodingType.equals(encodingType)) {
            throw new ApplicationRuntimeException(FormMessages.encodingTypeContention((IComponent)this.form, encodingType, encodingType), (Object)this.form, null, null);
        }
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    protected void writeHiddenField(IMarkupWriter writer, String name, String id, String value) {
        writer.beginEmpty("input");
        writer.attribute("type", "hidden");
        writer.attribute("name", name);
        if (HiveMind.isNonBlank((String)id)) {
            writer.attribute("id", id);
        }
        writer.attribute("value", value == null ? "" : value);
        writer.println();
    }

    protected IMarkupWriter getHiddenWriter() {
        if (this.hiddenWriter != null) {
            return this.hiddenWriter;
        }
        if (this.ajaxRequest != null && this.response != null && this.ajaxRequest.isValidRequest()) {
            log.debug((Object)"getHiddenWriter() ajax request is valid");
            if (!NullWriter.class.isInstance(this.writer)) {
                this.hiddenWriter = this.writer;
                return this.hiddenWriter;
            }
            this.hiddenWriter = this.response.getComponentWriter(this.form.getName() + "hidden");
            return this.hiddenWriter;
        }
        if (this.hiddenWriter == null) {
            this.hiddenWriter = this.writer;
        }
        return this.hiddenWriter;
    }

    private void writeHiddenField(String name, String id, String value) {
        IMarkupWriter fwriter = this.getHiddenWriter();
        this.writeHiddenField(fwriter, name, id, value);
    }

    protected void writeHiddenFields() {
        IMarkupWriter fwriter = this.getHiddenWriter();
        fwriter.begin("div");
        fwriter.attribute("style", "display:none;");
        fwriter.attribute("id", this.form.getName() + "hidden");
        this.writeHiddenFieldList();
        fwriter.end();
    }

    protected void writeHiddenFieldList() {
        this.writeHiddenField(FORM_IDS, null, this.buildAllocatedIdList());
        Iterator i = this.hiddenValues.iterator();
        while (i.hasNext()) {
            HiddenFieldData data = (HiddenFieldData)i.next();
            this.writeHiddenField(data.getName(), data.getId(), data.getValue());
        }
    }

    private void addHiddenFieldsForLinkParameter(ILink link, String parameterName) {
        String[] values = link.getParameterValues(parameterName);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            this.addHiddenValue(parameterName, values[i]);
        }
    }

    protected void writeTag(IMarkupWriter writer, String method, String url) {
        writer.begin("form");
        writer.attribute("method", method);
        writer.attribute("action", url);
    }

    public void prerenderField(IMarkupWriter writer, IComponent field, Location location) {
        Defense.notNull((Object)writer, (String)"writer");
        Defense.notNull((Object)field, (String)"field");
        String key = field.getExtendedId();
        if (this.prerenderMap.containsKey(key)) {
            throw new ApplicationRuntimeException(FormMessages.fieldAlreadyPrerendered(field), location, null);
        }
        NestedMarkupWriter nested = writer.getNestedWriter();
        field.render((IMarkupWriter)nested, this.cycle);
        this.prerenderMap.put(key, nested.getBuffer());
    }

    public boolean wasPrerendered(IMarkupWriter writer, IComponent field) {
        String key = field.getExtendedId();
        if (!this.prerenderMap.containsKey(key)) {
            return false;
        }
        String buffer = (String)this.prerenderMap.get(key);
        writer.printRaw(buffer);
        this.prerenderMap.remove(key);
        return true;
    }

    public void addDeferredRunnable(Runnable runnable) {
        Defense.notNull((Object)runnable, (String)"runnable");
        this.deferredRunnables.add(runnable);
    }

    public void registerForFocus(IFormComponent field, int priority) {
        this.delegate.registerForFocus(field, priority);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(ServiceConstants.RESERVED_IDS));
        set.add(FORM_IDS);
        set.add(RESERVED_FORM_IDS);
        set.add(SUBMIT_MODE);
        set.add("submitname");
        _standardReservedIds = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("cancel");
        set.add("submit");
        set.add("refresh");
        _submitModes = Collections.unmodifiableSet(set);
    }
}

