/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.awt.Point;
import java.util.Map;
import net.sf.tacos.ajax.components.AbstractSubmit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.IFormComponent;

public abstract class AjaxImageSubmit
extends AbstractSubmit {
    private static final Log log = LogFactory.getLog((Class)AjaxImageSubmit.class);

    public abstract IAsset getDisabledImage();

    public abstract IAsset getImage();

    public abstract String getNameOverride();

    public abstract void setPoint(Point var1);

    public abstract IScript getScript();

    protected void setName(IForm form) {
        String nameOverride = this.getNameOverride();
        this.setName(nameOverride == null ? form.getElementId((IFormComponent)this) : form.getElementId((IFormComponent)this, nameOverride));
    }

    protected void handleClick(IRequestCycle cycle, IForm form) {
        if (this.isParameterBound("point")) {
            int x = Integer.parseInt(cycle.getParameter(this.getName() + ".x"));
            int y = Integer.parseInt(cycle.getParameter(this.getName() + ".y"));
            this.setPoint(new Point(x, y));
        }
        super.handleClick(cycle, form);
    }

    protected boolean isClicked(IRequestCycle cycle, String name) {
        String parameterName = name + ".x";
        String value = cycle.getParameter(name);
        if (value == null) {
            value = cycle.getParameter("_tacos_fix_" + name);
        }
        log.debug((Object)("isClicked(" + name + ") with value:" + value));
        return HiveMind.isNonBlank((String)value);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean disabled = this.isDisabled();
        IAsset disabledImage = this.getDisabledImage();
        IAsset finalImage = disabled && disabledImage != null ? disabledImage : this.getImage();
        String imageURL = finalImage.buildURL();
        writer.beginEmpty("input");
        writer.attribute("type", "image");
        writer.attribute("name", this.getName());
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        writer.attribute("border", 0);
        writer.attribute("src", imageURL);
        this.renderIdAttribute(writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
        if (!this.isDisabled()) {
            Map parmMap = this.constructScriptParameter(cycle);
            PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
            this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, parmMap);
        }
    }

    public String getComponentId() {
        return this.getClientId();
    }

    public String getHiddenId() {
        return this.getName();
    }

    public boolean isDeferred() {
        return false;
    }
}

