/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import net.sf.tacos.ajax.AjaxWebRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.NullWriter;

public abstract class Dialog
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)Dialog.class);

    public abstract IScript getScript();

    public abstract AjaxWebRequest getAjaxRequest();

    public abstract void setHidden(boolean var1);

    public abstract boolean isHidden();

    public void hide() {
        this.setHidden(true);
        AjaxWebRequest ajaxr = this.getAjaxRequest();
        if (ajaxr != null && ajaxr.isValidRequest()) {
            ajaxr.addPreProcessScript(this.generateHide(true));
            ajaxr.addPostProcessScript(this.initializeScript());
        }
    }

    public void show() {
        this.setHidden(false);
    }

    protected String generateHide(boolean renderHide) {
        StringBuffer str = new StringBuffer();
        str.append("<script>\n");
        str.append("var cdialog = dojo.widget.byId(\"").append(this.getId()).append("\");\n").append("if (cdialog) {\n");
        str.append(" var ndialog = document.createElement(\"div\");\n").append("ndialog.setAttribute(\"id\", \"").append(this.getId()).append("\");\n");
        str.append(" ndialog.style.display = \"none\";");
        str.append(" document.body.appendChild(ndialog);\n");
        if (renderHide) {
            str.append(" cdialog.hide(); \n");
        }
        str.append("}");
        str.append("</script>");
        return str.toString();
    }

    protected String initializeScript() {
        StringBuffer str = new StringBuffer();
        str.append("<script>\n");
        str.append("tacos.buildDialog(true, \"").append(this.getId()).append("\", ").append(this.isHidden()).append(");\n");
        str.append("</script>");
        return str.toString();
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean ajaxRequest = false;
        AjaxWebRequest ajaxr = this.getAjaxRequest();
        if (ajaxr != null && ajaxr.isValidRequest()) {
            ajaxRequest = true;
        }
        if (!this.isHidden() && ajaxRequest && (ajaxr.containsComponentId(this.getId()) || !(writer instanceof NullWriter))) {
            ajaxr.addPreProcessScript(this.generateHide(false));
        }
        writer.begin("div");
        writer.attribute("id", this.getId());
        writer.attribute("style", "display:none");
        super.renderInformalParameters(writer, cycle);
        super.renderBody(writer, cycle);
        writer.end();
        if (writer instanceof NullWriter) {
            return;
        }
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        scriptParms.put("ajax", ajaxRequest);
        scriptParms.put("compId", this.getId());
        scriptParms.put("hidden", this.isHidden());
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }
}

