/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.Collection;
import java.util.HashMap;
import net.sf.tacos.ajax.AjaxDirectService;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.listener.ListenerInvoker;

public abstract class Editor
extends AbstractComponent
implements IDirect {
    private static final Log log = LogFactory.getLog((Class)Editor.class);

    public abstract AjaxDirectService getAjaxEngine();

    public abstract ListenerInvoker getListenerInvoker();

    public abstract IScript getScript();

    public abstract IActionListener getListener();

    public abstract IActionListener getCancel();

    public abstract boolean isDirect();

    public abstract String getElement();

    public abstract String getItems();

    public abstract boolean isDisabled();

    public abstract boolean getRefreshContents();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setValueUpdate(boolean var1);

    public abstract boolean isValueUpdate();

    public abstract Collection getUpdateComponents();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean ajaxRequest;
        if (cycle.isRewinding()) {
            return;
        }
        Object value = this.getBinding("value").getObject();
        if (value == null) {
            value = "";
        }
        if ((ajaxRequest = this.getAjaxEngine().getAjaxRequest().isValidRequest()) && this.isValueUpdate()) {
            this.getAjaxEngine().getAjaxRequest().getResponseBuilder().removeComponentWriter(this.getId());
            if (this.isDisabled()) {
                String js = "";
                if (this.getRefreshContents()) {
                    js = "dojo.byId('" + this.getId() + "').innerHTML='" + StringEscapeUtils.escapeJavaScript((String)((String)value)) + "';";
                }
                js = js + "ew.disableToolbar(true);ew.destroy();";
                this.getAjaxEngine().getAjaxRequest().getResponseBuilder().getScriptWriter().printRaw("<script type=\"text/javascript\">var ew = dojo.widget.byId('" + this.getId() + "HtmlEditor');" + " if (ew) {" + js + "}" + "</script>");
            }
            return;
        }
        if (ajaxRequest && !this.getAjaxEngine().getAjaxRequest().containsComponentId(this.getId()) && writer instanceof NullWriter) {
            return;
        }
        writer.begin(this.getElement());
        writer.attribute("id", this.getId());
        this.renderInformalParameters(writer, cycle);
        writer.printRaw(value.toString());
        writer.end();
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        if (this.isDisabled()) {
            pageRenderSupport.addInitializationScript("dojo.require(\"dojo.widget.Editor\");");
            return;
        }
        String[] updateComponents = new String[]{};
        if (this.getUpdateComponents() != null) {
            updateComponents = this.getUpdateComponents().toArray(new String[this.getUpdateComponents().size()]);
        }
        AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this, (Object[])new String[]{this.getId()}, updateComponents, this.isDirect());
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        scriptParms.put("updateUrl", this.getAjaxEngine().getLink(false, (Object)dsp).getAbsoluteURL());
        scriptParms.put("fieldName", this.getId());
        scriptParms.put("items", this.getItems() != null ? this.getItems() : "");
        scriptParms.put("ajax", ajaxRequest);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    public void trigger(IRequestCycle cycle) {
        IActionListener listener = this.getListener();
        IActionListener cancel = this.getCancel();
        String paramName = (String)cycle.getListenerParameters()[0];
        String value = cycle.getParameter(paramName);
        log.debug((Object)("Editor paramName:" + paramName + " value:" + value + " listener:" + listener));
        this.setValueUpdate(true);
        if (value != null) {
            this.getBinding("value").setObject((Object)value);
            if (listener != null) {
                this.getListenerInvoker().invokeListener(listener, (IComponent)this, cycle);
            }
        } else if (cancel != null) {
            this.getListenerInvoker().invokeListener(cancel, (IComponent)this, cycle);
        }
    }
}

