/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import net.sf.tacos.ajax.AjaxDirectService;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.AbstractFormComponent;

public abstract class HtmlArea
extends AbstractFormComponent {
    private static final String COMPACT = "'textGroup','colorGroup','|','justifyGroup','|','listGroup'";
    private static final String NORMAL = "'blockGroup','textGroup','colorGroup','|','justifyGroup','|','listGroup','indentGroup','|','linkGroup'";
    private static final String EXTENDED = "'commandGroup','|','blockGroup','textGroup','colorGroup','|','justifyGroup','|','listGroup','indentGroup','|','linkGroup'";

    public abstract String getMode();

    public abstract String getValue();

    public abstract void setValue(String var1);

    public abstract AjaxDirectService getAjaxEngine();

    public String getItems() {
        if (this.getMode().equalsIgnoreCase("compact")) {
            return COMPACT;
        }
        if (this.getMode().equalsIgnoreCase("extended")) {
            return EXTENDED;
        }
        if (this.getMode().equalsIgnoreCase("normal")) {
            return NORMAL;
        }
        return this.getMode();
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        boolean ajaxRequest = this.getAjaxEngine().getAjaxRequest().isValidRequest();
        this.renderDelegatePrefix(writer, cycle);
        writer.begin("textarea");
        writer.attribute("name", this.getName());
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.printRaw(this.getValue());
        writer.end();
        this.renderDelegateSuffix(writer, cycle);
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        scriptParms.put("fieldName", this.getClientId());
        scriptParms.put("items", this.getItems());
        scriptParms.put("ajax", ajaxRequest);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        this.setValue(value);
    }

    public abstract IScript getScript();
}

